<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for claimStateSiteView StructType
 * @subpackage Structs
 */
class ClaimStateSiteView extends AbstractStructBase
{
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ClaimDocumentSiteView[]
     */
    public $documents;
    /**
     * The isPassed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPassed;
    /**
     * The stateName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stateName;
    /**
     * Constructor method for claimStateSiteView
     * @uses ClaimStateSiteView::setDocuments()
     * @uses ClaimStateSiteView::setIsPassed()
     * @uses ClaimStateSiteView::setStateName()
     * @param \App\Insis\StructType\ClaimDocumentSiteView[] $documents
     * @param bool $isPassed
     * @param string $stateName
     */
    public function __construct(array $documents = array(), $isPassed = null, $stateName = null)
    {
        $this
            ->setDocuments($documents)
            ->setIsPassed($isPassed)
            ->setStateName($stateName);
    }
    /**
     * Get documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ClaimDocumentSiteView[]|null
     */
    public function getDocuments()
    {
        return isset($this->documents) ? $this->documents : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $claimStateSiteViewDocumentsItem) {
            // validation for constraint: itemType
            if (!$claimStateSiteViewDocumentsItem instanceof \App\Insis\StructType\ClaimDocumentSiteView) {
                $invalidValues[] = is_object($claimStateSiteViewDocumentsItem) ? get_class($claimStateSiteViewDocumentsItem) : sprintf('%s(%s)', gettype($claimStateSiteViewDocumentsItem), var_export($claimStateSiteViewDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documents property can only contain items of type \App\Insis\StructType\ClaimDocumentSiteView, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ClaimDocumentSiteView[] $documents
     * @return \App\Insis\StructType\ClaimStateSiteView
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->documents);
        } else {
            $this->documents = $documents;
        }
        return $this;
    }
    /**
     * Add item to documents value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ClaimDocumentSiteView $item
     * @return \App\Insis\StructType\ClaimStateSiteView
     */
    public function addToDocuments(\App\Insis\StructType\ClaimDocumentSiteView $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ClaimDocumentSiteView) {
            throw new \InvalidArgumentException(sprintf('The documents property can only contain items of type \App\Insis\StructType\ClaimDocumentSiteView, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documents[] = $item;
        return $this;
    }
    /**
     * Get isPassed value
     * @return bool|null
     */
    public function getIsPassed()
    {
        return $this->isPassed;
    }
    /**
     * Set isPassed value
     * @param bool $isPassed
     * @return \App\Insis\StructType\ClaimStateSiteView
     */
    public function setIsPassed($isPassed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPassed) && !is_bool($isPassed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPassed, true), gettype($isPassed)), __LINE__);
        }
        $this->isPassed = $isPassed;
        return $this;
    }
    /**
     * Get stateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->stateName;
    }
    /**
     * Set stateName value
     * @param string $stateName
     * @return \App\Insis\StructType\ClaimStateSiteView
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateName, true), gettype($stateName)), __LINE__);
        }
        $this->stateName = $stateName;
        return $this;
    }
}
