<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for claim StructType
 * @subpackage Structs
 */
class Claim extends AbstractStructBase
{
    /**
     * The claimDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $claimDate;
    /**
     * The claimID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $claimID;
    /**
     * The claimStates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ClaimState[]
     */
    public $claimStates;
    /**
     * The guiltyManID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $guiltyManID;
    /**
     * The initialReserveAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $initialReserveAmount;
    /**
     * The initialReserveCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $initialReserveCurrency;
    /**
     * The injuredManID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $injuredManID;
    /**
     * The injuredObjectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $injuredObjectID;
    /**
     * The injuredObjectType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $injuredObjectType;
    /**
     * The payAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $payAmount;
    /**
     * The payCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payCurrency;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * Constructor method for claim
     * @uses Claim::setClaimDate()
     * @uses Claim::setClaimID()
     * @uses Claim::setClaimStates()
     * @uses Claim::setGuiltyManID()
     * @uses Claim::setInitialReserveAmount()
     * @uses Claim::setInitialReserveCurrency()
     * @uses Claim::setInjuredManID()
     * @uses Claim::setInjuredObjectID()
     * @uses Claim::setInjuredObjectType()
     * @uses Claim::setPayAmount()
     * @uses Claim::setPayCurrency()
     * @uses Claim::setPolicyID()
     * @param string $claimDate
     * @param int $claimID
     * @param \App\Insis\StructType\ClaimState[] $claimStates
     * @param int $guiltyManID
     * @param float $initialReserveAmount
     * @param string $initialReserveCurrency
     * @param int $injuredManID
     * @param int $injuredObjectID
     * @param int $injuredObjectType
     * @param float $payAmount
     * @param string $payCurrency
     * @param int $policyID
     */
    public function __construct($claimDate = null, $claimID = null, array $claimStates = array(), $guiltyManID = null, $initialReserveAmount = null, $initialReserveCurrency = null, $injuredManID = null, $injuredObjectID = null, $injuredObjectType = null, $payAmount = null, $payCurrency = null, $policyID = null)
    {
        $this
            ->setClaimDate($claimDate)
            ->setClaimID($claimID)
            ->setClaimStates($claimStates)
            ->setGuiltyManID($guiltyManID)
            ->setInitialReserveAmount($initialReserveAmount)
            ->setInitialReserveCurrency($initialReserveCurrency)
            ->setInjuredManID($injuredManID)
            ->setInjuredObjectID($injuredObjectID)
            ->setInjuredObjectType($injuredObjectType)
            ->setPayAmount($payAmount)
            ->setPayCurrency($payCurrency)
            ->setPolicyID($policyID);
    }
    /**
     * Get claimDate value
     * @return string|null
     */
    public function getClaimDate()
    {
        return $this->claimDate;
    }
    /**
     * Set claimDate value
     * @param string $claimDate
     * @return \App\Insis\StructType\Claim
     */
    public function setClaimDate($claimDate = null)
    {
        // validation for constraint: string
        if (!is_null($claimDate) && !is_string($claimDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimDate, true), gettype($claimDate)), __LINE__);
        }
        $this->claimDate = $claimDate;
        return $this;
    }
    /**
     * Get claimID value
     * @return int|null
     */
    public function getClaimID()
    {
        return $this->claimID;
    }
    /**
     * Set claimID value
     * @param int $claimID
     * @return \App\Insis\StructType\Claim
     */
    public function setClaimID($claimID = null)
    {
        // validation for constraint: int
        if (!is_null($claimID) && !(is_int($claimID) || ctype_digit($claimID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($claimID, true), gettype($claimID)), __LINE__);
        }
        $this->claimID = $claimID;
        return $this;
    }
    /**
     * Get claimStates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ClaimState[]|null
     */
    public function getClaimStates()
    {
        return isset($this->claimStates) ? $this->claimStates : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClaimStates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimStates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaimStatesForArrayConstraintsFromSetClaimStates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $claimClaimStatesItem) {
            // validation for constraint: itemType
            if (!$claimClaimStatesItem instanceof \App\Insis\StructType\ClaimState) {
                $invalidValues[] = is_object($claimClaimStatesItem) ? get_class($claimClaimStatesItem) : sprintf('%s(%s)', gettype($claimClaimStatesItem), var_export($claimClaimStatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The claimStates property can only contain items of type \App\Insis\StructType\ClaimState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set claimStates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ClaimState[] $claimStates
     * @return \App\Insis\StructType\Claim
     */
    public function setClaimStates(array $claimStates = array())
    {
        // validation for constraint: array
        if ('' !== ($claimStatesArrayErrorMessage = self::validateClaimStatesForArrayConstraintsFromSetClaimStates($claimStates))) {
            throw new \InvalidArgumentException($claimStatesArrayErrorMessage, __LINE__);
        }
        if (is_null($claimStates) || (is_array($claimStates) && empty($claimStates))) {
            unset($this->claimStates);
        } else {
            $this->claimStates = $claimStates;
        }
        return $this;
    }
    /**
     * Add item to claimStates value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ClaimState $item
     * @return \App\Insis\StructType\Claim
     */
    public function addToClaimStates(\App\Insis\StructType\ClaimState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ClaimState) {
            throw new \InvalidArgumentException(sprintf('The claimStates property can only contain items of type \App\Insis\StructType\ClaimState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->claimStates[] = $item;
        return $this;
    }
    /**
     * Get guiltyManID value
     * @return int|null
     */
    public function getGuiltyManID()
    {
        return $this->guiltyManID;
    }
    /**
     * Set guiltyManID value
     * @param int $guiltyManID
     * @return \App\Insis\StructType\Claim
     */
    public function setGuiltyManID($guiltyManID = null)
    {
        // validation for constraint: int
        if (!is_null($guiltyManID) && !(is_int($guiltyManID) || ctype_digit($guiltyManID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($guiltyManID, true), gettype($guiltyManID)), __LINE__);
        }
        $this->guiltyManID = $guiltyManID;
        return $this;
    }
    /**
     * Get initialReserveAmount value
     * @return float|null
     */
    public function getInitialReserveAmount()
    {
        return $this->initialReserveAmount;
    }
    /**
     * Set initialReserveAmount value
     * @param float $initialReserveAmount
     * @return \App\Insis\StructType\Claim
     */
    public function setInitialReserveAmount($initialReserveAmount = null)
    {
        // validation for constraint: float
        if (!is_null($initialReserveAmount) && !(is_float($initialReserveAmount) || is_numeric($initialReserveAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($initialReserveAmount, true), gettype($initialReserveAmount)), __LINE__);
        }
        $this->initialReserveAmount = $initialReserveAmount;
        return $this;
    }
    /**
     * Get initialReserveCurrency value
     * @return string|null
     */
    public function getInitialReserveCurrency()
    {
        return $this->initialReserveCurrency;
    }
    /**
     * Set initialReserveCurrency value
     * @param string $initialReserveCurrency
     * @return \App\Insis\StructType\Claim
     */
    public function setInitialReserveCurrency($initialReserveCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($initialReserveCurrency) && !is_string($initialReserveCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialReserveCurrency, true), gettype($initialReserveCurrency)), __LINE__);
        }
        $this->initialReserveCurrency = $initialReserveCurrency;
        return $this;
    }
    /**
     * Get injuredManID value
     * @return int|null
     */
    public function getInjuredManID()
    {
        return $this->injuredManID;
    }
    /**
     * Set injuredManID value
     * @param int $injuredManID
     * @return \App\Insis\StructType\Claim
     */
    public function setInjuredManID($injuredManID = null)
    {
        // validation for constraint: int
        if (!is_null($injuredManID) && !(is_int($injuredManID) || ctype_digit($injuredManID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($injuredManID, true), gettype($injuredManID)), __LINE__);
        }
        $this->injuredManID = $injuredManID;
        return $this;
    }
    /**
     * Get injuredObjectID value
     * @return int|null
     */
    public function getInjuredObjectID()
    {
        return $this->injuredObjectID;
    }
    /**
     * Set injuredObjectID value
     * @param int $injuredObjectID
     * @return \App\Insis\StructType\Claim
     */
    public function setInjuredObjectID($injuredObjectID = null)
    {
        // validation for constraint: int
        if (!is_null($injuredObjectID) && !(is_int($injuredObjectID) || ctype_digit($injuredObjectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($injuredObjectID, true), gettype($injuredObjectID)), __LINE__);
        }
        $this->injuredObjectID = $injuredObjectID;
        return $this;
    }
    /**
     * Get injuredObjectType value
     * @return int|null
     */
    public function getInjuredObjectType()
    {
        return $this->injuredObjectType;
    }
    /**
     * Set injuredObjectType value
     * @param int $injuredObjectType
     * @return \App\Insis\StructType\Claim
     */
    public function setInjuredObjectType($injuredObjectType = null)
    {
        // validation for constraint: int
        if (!is_null($injuredObjectType) && !(is_int($injuredObjectType) || ctype_digit($injuredObjectType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($injuredObjectType, true), gettype($injuredObjectType)), __LINE__);
        }
        $this->injuredObjectType = $injuredObjectType;
        return $this;
    }
    /**
     * Get payAmount value
     * @return float|null
     */
    public function getPayAmount()
    {
        return $this->payAmount;
    }
    /**
     * Set payAmount value
     * @param float $payAmount
     * @return \App\Insis\StructType\Claim
     */
    public function setPayAmount($payAmount = null)
    {
        // validation for constraint: float
        if (!is_null($payAmount) && !(is_float($payAmount) || is_numeric($payAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payAmount, true), gettype($payAmount)), __LINE__);
        }
        $this->payAmount = $payAmount;
        return $this;
    }
    /**
     * Get payCurrency value
     * @return string|null
     */
    public function getPayCurrency()
    {
        return $this->payCurrency;
    }
    /**
     * Set payCurrency value
     * @param string $payCurrency
     * @return \App\Insis\StructType\Claim
     */
    public function setPayCurrency($payCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($payCurrency) && !is_string($payCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payCurrency, true), gettype($payCurrency)), __LINE__);
        }
        $this->payCurrency = $payCurrency;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\Claim
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
}
