<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkPeopleIIN StructType
 * Meta information extracted from the WSDL
 * - type: tns:checkPeopleIIN
 * @subpackage Structs
 */
class CheckPeopleIIN extends AbstractStructBase
{
    /**
     * The aIIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aIIN;
    /**
     * The aManComp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aManComp;
    /**
     * Constructor method for checkPeopleIIN
     * @uses CheckPeopleIIN::setAIIN()
     * @uses CheckPeopleIIN::setAManComp()
     * @param string $aIIN
     * @param int $aManComp
     */
    public function __construct($aIIN = null, $aManComp = null)
    {
        $this
            ->setAIIN($aIIN)
            ->setAManComp($aManComp);
    }
    /**
     * Get aIIN value
     * @return string|null
     */
    public function getAIIN()
    {
        return $this->aIIN;
    }
    /**
     * Set aIIN value
     * @param string $aIIN
     * @return \App\Insis\StructType\CheckPeopleIIN
     */
    public function setAIIN($aIIN = null)
    {
        // validation for constraint: string
        if (!is_null($aIIN) && !is_string($aIIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aIIN, true), gettype($aIIN)), __LINE__);
        }
        $this->aIIN = $aIIN;
        return $this;
    }
    /**
     * Get aManComp value
     * @return int|null
     */
    public function getAManComp()
    {
        return $this->aManComp;
    }
    /**
     * Set aManComp value
     * @param int $aManComp
     * @return \App\Insis\StructType\CheckPeopleIIN
     */
    public function setAManComp($aManComp = null)
    {
        // validation for constraint: int
        if (!is_null($aManComp) && !(is_int($aManComp) || ctype_digit($aManComp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aManComp, true), gettype($aManComp)), __LINE__);
        }
        $this->aManComp = $aManComp;
        return $this;
    }
}
