<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkFormats StructType
 * Meta information extracted from the WSDL
 * - type: tns:checkFormats
 * @subpackage Structs
 */
class CheckFormats extends AbstractStructBase
{
    /**
     * The text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $text;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * The amnt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amnt;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * Constructor method for checkFormats
     * @uses CheckFormats::setText()
     * @uses CheckFormats::setData()
     * @uses CheckFormats::setAmnt()
     * @uses CheckFormats::setNumber()
     * @param string $text
     * @param string $data
     * @param float $amnt
     * @param int $number
     */
    public function __construct($text = null, $data = null, $amnt = null, $number = null)
    {
        $this
            ->setText($text)
            ->setData($data)
            ->setAmnt($amnt)
            ->setNumber($number);
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \App\Insis\StructType\CheckFormats
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \App\Insis\StructType\CheckFormats
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get amnt value
     * @return float|null
     */
    public function getAmnt()
    {
        return $this->amnt;
    }
    /**
     * Set amnt value
     * @param float $amnt
     * @return \App\Insis\StructType\CheckFormats
     */
    public function setAmnt($amnt = null)
    {
        // validation for constraint: float
        if (!is_null($amnt) && !(is_float($amnt) || is_numeric($amnt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amnt, true), gettype($amnt)), __LINE__);
        }
        $this->amnt = $amnt;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \App\Insis\StructType\CheckFormats
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
