<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bordero StructType
 * @subpackage Structs
 */
class Bordero extends AbstractStructBase
{
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The blankNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankNumber;
    /**
     * The client
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\People
     */
    public $client;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The insuredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insuredValue;
    /**
     * The issueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The params
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $params;
    /**
     * The premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $premium;
    /**
     * Constructor method for bordero
     * @uses Bordero::setBeginDate()
     * @uses Bordero::setBlankNumber()
     * @uses Bordero::setClient()
     * @uses Bordero::setEndDate()
     * @uses Bordero::setInsuredValue()
     * @uses Bordero::setIssueDate()
     * @uses Bordero::setParams()
     * @uses Bordero::setPremium()
     * @param string $beginDate
     * @param string $blankNumber
     * @param \App\Insis\StructType\People $client
     * @param string $endDate
     * @param float $insuredValue
     * @param string $issueDate
     * @param \App\Insis\StructType\ObjectParam[] $params
     * @param float $premium
     */
    public function __construct($beginDate = null, $blankNumber = null, \App\Insis\StructType\People $client = null, $endDate = null, $insuredValue = null, $issueDate = null, array $params = array(), $premium = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setBlankNumber($blankNumber)
            ->setClient($client)
            ->setEndDate($endDate)
            ->setInsuredValue($insuredValue)
            ->setIssueDate($issueDate)
            ->setParams($params)
            ->setPremium($premium);
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\Bordero
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get blankNumber value
     * @return string|null
     */
    public function getBlankNumber()
    {
        return $this->blankNumber;
    }
    /**
     * Set blankNumber value
     * @param string $blankNumber
     * @return \App\Insis\StructType\Bordero
     */
    public function setBlankNumber($blankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blankNumber) && !is_string($blankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankNumber, true), gettype($blankNumber)), __LINE__);
        }
        $this->blankNumber = $blankNumber;
        return $this;
    }
    /**
     * Get client value
     * @return \App\Insis\StructType\People|null
     */
    public function getClient()
    {
        return $this->client;
    }
    /**
     * Set client value
     * @param \App\Insis\StructType\People $client
     * @return \App\Insis\StructType\Bordero
     */
    public function setClient(\App\Insis\StructType\People $client = null)
    {
        $this->client = $client;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\Bordero
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get insuredValue value
     * @return float|null
     */
    public function getInsuredValue()
    {
        return $this->insuredValue;
    }
    /**
     * Set insuredValue value
     * @param float $insuredValue
     * @return \App\Insis\StructType\Bordero
     */
    public function setInsuredValue($insuredValue = null)
    {
        // validation for constraint: float
        if (!is_null($insuredValue) && !(is_float($insuredValue) || is_numeric($insuredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuredValue, true), gettype($insuredValue)), __LINE__);
        }
        $this->insuredValue = $insuredValue;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \App\Insis\StructType\Bordero
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get params value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getParams()
    {
        return isset($this->params) ? $this->params : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParamsForArrayConstraintsFromSetParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $borderoParamsItem) {
            // validation for constraint: itemType
            if (!$borderoParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($borderoParamsItem) ? get_class($borderoParamsItem) : sprintf('%s(%s)', gettype($borderoParamsItem), var_export($borderoParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The params property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set params value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $params
     * @return \App\Insis\StructType\Bordero
     */
    public function setParams(array $params = array())
    {
        // validation for constraint: array
        if ('' !== ($paramsArrayErrorMessage = self::validateParamsForArrayConstraintsFromSetParams($params))) {
            throw new \InvalidArgumentException($paramsArrayErrorMessage, __LINE__);
        }
        if (is_null($params) || (is_array($params) && empty($params))) {
            unset($this->params);
        } else {
            $this->params = $params;
        }
        return $this;
    }
    /**
     * Add item to params value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Bordero
     */
    public function addToParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The params property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->params[] = $item;
        return $this;
    }
    /**
     * Get premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param float $premium
     * @return \App\Insis\StructType\Bordero
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
}
