<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for blankOrder StructType
 * @subpackage Structs
 */
class BlankOrder extends AbstractStructBase
{
    /**
     * The operationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationCode;
    /**
     * The orderBlanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\PolicyBlanks[]
     */
    public $orderBlanks;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderDate;
    /**
     * The orderFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderFrom;
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderID;
    /**
     * The orderNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNO;
    /**
     * The orderOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderOwner;
    /**
     * The orderTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderTo;
    /**
     * Constructor method for blankOrder
     * @uses BlankOrder::setOperationCode()
     * @uses BlankOrder::setOrderBlanks()
     * @uses BlankOrder::setOrderDate()
     * @uses BlankOrder::setOrderFrom()
     * @uses BlankOrder::setOrderID()
     * @uses BlankOrder::setOrderNO()
     * @uses BlankOrder::setOrderOwner()
     * @uses BlankOrder::setOrderTo()
     * @param int $operationCode
     * @param \App\Insis\StructType\PolicyBlanks[] $orderBlanks
     * @param string $orderDate
     * @param int $orderFrom
     * @param int $orderID
     * @param string $orderNO
     * @param int $orderOwner
     * @param int $orderTo
     */
    public function __construct($operationCode = null, array $orderBlanks = array(), $orderDate = null, $orderFrom = null, $orderID = null, $orderNO = null, $orderOwner = null, $orderTo = null)
    {
        $this
            ->setOperationCode($operationCode)
            ->setOrderBlanks($orderBlanks)
            ->setOrderDate($orderDate)
            ->setOrderFrom($orderFrom)
            ->setOrderID($orderID)
            ->setOrderNO($orderNO)
            ->setOrderOwner($orderOwner)
            ->setOrderTo($orderTo);
    }
    /**
     * Get operationCode value
     * @return int|null
     */
    public function getOperationCode()
    {
        return $this->operationCode;
    }
    /**
     * Set operationCode value
     * @param int $operationCode
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOperationCode($operationCode = null)
    {
        // validation for constraint: int
        if (!is_null($operationCode) && !(is_int($operationCode) || ctype_digit($operationCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationCode, true), gettype($operationCode)), __LINE__);
        }
        $this->operationCode = $operationCode;
        return $this;
    }
    /**
     * Get orderBlanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\PolicyBlanks[]|null
     */
    public function getOrderBlanks()
    {
        return isset($this->orderBlanks) ? $this->orderBlanks : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderBlanks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderBlanks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderBlanksForArrayConstraintsFromSetOrderBlanks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $blankOrderOrderBlanksItem) {
            // validation for constraint: itemType
            if (!$blankOrderOrderBlanksItem instanceof \App\Insis\StructType\PolicyBlanks) {
                $invalidValues[] = is_object($blankOrderOrderBlanksItem) ? get_class($blankOrderOrderBlanksItem) : sprintf('%s(%s)', gettype($blankOrderOrderBlanksItem), var_export($blankOrderOrderBlanksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderBlanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderBlanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks[] $orderBlanks
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderBlanks(array $orderBlanks = array())
    {
        // validation for constraint: array
        if ('' !== ($orderBlanksArrayErrorMessage = self::validateOrderBlanksForArrayConstraintsFromSetOrderBlanks($orderBlanks))) {
            throw new \InvalidArgumentException($orderBlanksArrayErrorMessage, __LINE__);
        }
        if (is_null($orderBlanks) || (is_array($orderBlanks) && empty($orderBlanks))) {
            unset($this->orderBlanks);
        } else {
            $this->orderBlanks = $orderBlanks;
        }
        return $this;
    }
    /**
     * Add item to orderBlanks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks $item
     * @return \App\Insis\StructType\BlankOrder
     */
    public function addToOrderBlanks(\App\Insis\StructType\PolicyBlanks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PolicyBlanks) {
            throw new \InvalidArgumentException(sprintf('The orderBlanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderBlanks[] = $item;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get orderFrom value
     * @return int|null
     */
    public function getOrderFrom()
    {
        return $this->orderFrom;
    }
    /**
     * Set orderFrom value
     * @param int $orderFrom
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderFrom($orderFrom = null)
    {
        // validation for constraint: int
        if (!is_null($orderFrom) && !(is_int($orderFrom) || ctype_digit($orderFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderFrom, true), gettype($orderFrom)), __LINE__);
        }
        $this->orderFrom = $orderFrom;
        return $this;
    }
    /**
     * Get orderID value
     * @return int|null
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get orderNO value
     * @return string|null
     */
    public function getOrderNO()
    {
        return $this->orderNO;
    }
    /**
     * Set orderNO value
     * @param string $orderNO
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderNO($orderNO = null)
    {
        // validation for constraint: string
        if (!is_null($orderNO) && !is_string($orderNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNO, true), gettype($orderNO)), __LINE__);
        }
        $this->orderNO = $orderNO;
        return $this;
    }
    /**
     * Get orderOwner value
     * @return int|null
     */
    public function getOrderOwner()
    {
        return $this->orderOwner;
    }
    /**
     * Set orderOwner value
     * @param int $orderOwner
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderOwner($orderOwner = null)
    {
        // validation for constraint: int
        if (!is_null($orderOwner) && !(is_int($orderOwner) || ctype_digit($orderOwner))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderOwner, true), gettype($orderOwner)), __LINE__);
        }
        $this->orderOwner = $orderOwner;
        return $this;
    }
    /**
     * Get orderTo value
     * @return int|null
     */
    public function getOrderTo()
    {
        return $this->orderTo;
    }
    /**
     * Set orderTo value
     * @param int $orderTo
     * @return \App\Insis\StructType\BlankOrder
     */
    public function setOrderTo($orderTo = null)
    {
        // validation for constraint: int
        if (!is_null($orderTo) && !(is_int($orderTo) || ctype_digit($orderTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderTo, true), gettype($orderTo)), __LINE__);
        }
        $this->orderTo = $orderTo;
        return $this;
    }
}
