<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bankAccount StructType
 * @subpackage Structs
 */
class BankAccount extends AbstractStructBase
{
    /**
     * The billNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billNo;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The manId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manId;
    /**
     * Constructor method for bankAccount
     * @uses BankAccount::setBillNo()
     * @uses BankAccount::setCurrency()
     * @uses BankAccount::setManId()
     * @param string $billNo
     * @param string $currency
     * @param int $manId
     */
    public function __construct($billNo = null, $currency = null, $manId = null)
    {
        $this
            ->setBillNo($billNo)
            ->setCurrency($currency)
            ->setManId($manId);
    }
    /**
     * Get billNo value
     * @return string|null
     */
    public function getBillNo()
    {
        return $this->billNo;
    }
    /**
     * Set billNo value
     * @param string $billNo
     * @return \App\Insis\StructType\BankAccount
     */
    public function setBillNo($billNo = null)
    {
        // validation for constraint: string
        if (!is_null($billNo) && !is_string($billNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billNo, true), gettype($billNo)), __LINE__);
        }
        $this->billNo = $billNo;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \App\Insis\StructType\BankAccount
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get manId value
     * @return int|null
     */
    public function getManId()
    {
        return $this->manId;
    }
    /**
     * Set manId value
     * @param int $manId
     * @return \App\Insis\StructType\BankAccount
     */
    public function setManId($manId = null)
    {
        // validation for constraint: int
        if (!is_null($manId) && !(is_int($manId) || ctype_digit($manId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manId, true), gettype($manId)), __LINE__);
        }
        $this->manId = $manId;
        return $this;
    }
}
