<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BTAException StructType
 * Meta information extracted from the WSDL
 * - type: tns:BTAException
 * @subpackage Structs
 */
class BTAException extends AbstractStructBase
{
    /**
     * The BTACode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BTACode;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for BTAException
     * @uses BTAException::setBTACode()
     * @uses BTAException::setMessage()
     * @param int $bTACode
     * @param string $message
     */
    public function __construct($bTACode = null, $message = null)
    {
        $this
            ->setBTACode($bTACode)
            ->setMessage($message);
    }
    /**
     * Get BTACode value
     * @return int|null
     */
    public function getBTACode()
    {
        return $this->BTACode;
    }
    /**
     * Set BTACode value
     * @param int $bTACode
     * @return \App\Insis\StructType\BTAException
     */
    public function setBTACode($bTACode = null)
    {
        // validation for constraint: int
        if (!is_null($bTACode) && !(is_int($bTACode) || ctype_digit($bTACode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bTACode, true), gettype($bTACode)), __LINE__);
        }
        $this->BTACode = $bTACode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \App\Insis\StructType\BTAException
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
