<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for archiveInfo StructType
 * @subpackage Structs
 */
class ArchiveInfo extends AbstractStructBase
{
    /**
     * The annexId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $annexId;
    /**
     * The archiveId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $archiveId;
    /**
     * The archived
     * @var bool
     */
    public $archived;
    /**
     * The blankNUmber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankNUmber;
    /**
     * The policyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyId;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * Constructor method for archiveInfo
     * @uses ArchiveInfo::setAnnexId()
     * @uses ArchiveInfo::setArchiveId()
     * @uses ArchiveInfo::setArchived()
     * @uses ArchiveInfo::setBlankNUmber()
     * @uses ArchiveInfo::setPolicyId()
     * @uses ArchiveInfo::setPrefix()
     * @param int $annexId
     * @param int $archiveId
     * @param bool $archived
     * @param string $blankNUmber
     * @param int $policyId
     * @param string $prefix
     */
    public function __construct($annexId = null, $archiveId = null, $archived = null, $blankNUmber = null, $policyId = null, $prefix = null)
    {
        $this
            ->setAnnexId($annexId)
            ->setArchiveId($archiveId)
            ->setArchived($archived)
            ->setBlankNUmber($blankNUmber)
            ->setPolicyId($policyId)
            ->setPrefix($prefix);
    }
    /**
     * Get annexId value
     * @return int|null
     */
    public function getAnnexId()
    {
        return $this->annexId;
    }
    /**
     * Set annexId value
     * @param int $annexId
     * @return \App\Insis\StructType\ArchiveInfo
     */
    public function setAnnexId($annexId = null)
    {
        // validation for constraint: int
        if (!is_null($annexId) && !(is_int($annexId) || ctype_digit($annexId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annexId, true), gettype($annexId)), __LINE__);
        }
        $this->annexId = $annexId;
        return $this;
    }
    /**
     * Get archiveId value
     * @return int|null
     */
    public function getArchiveId()
    {
        return $this->archiveId;
    }
    /**
     * Set archiveId value
     * @param int $archiveId
     * @return \App\Insis\StructType\ArchiveInfo
     */
    public function setArchiveId($archiveId = null)
    {
        // validation for constraint: int
        if (!is_null($archiveId) && !(is_int($archiveId) || ctype_digit($archiveId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($archiveId, true), gettype($archiveId)), __LINE__);
        }
        $this->archiveId = $archiveId;
        return $this;
    }
    /**
     * Get archived value
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->archived;
    }
    /**
     * Set archived value
     * @param bool $archived
     * @return \App\Insis\StructType\ArchiveInfo
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($archived, true), gettype($archived)), __LINE__);
        }
        $this->archived = $archived;
        return $this;
    }
    /**
     * Get blankNUmber value
     * @return string|null
     */
    public function getBlankNUmber()
    {
        return $this->blankNUmber;
    }
    /**
     * Set blankNUmber value
     * @param string $blankNUmber
     * @return \App\Insis\StructType\ArchiveInfo
     */
    public function setBlankNUmber($blankNUmber = null)
    {
        // validation for constraint: string
        if (!is_null($blankNUmber) && !is_string($blankNUmber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankNUmber, true), gettype($blankNUmber)), __LINE__);
        }
        $this->blankNUmber = $blankNUmber;
        return $this;
    }
    /**
     * Get policyId value
     * @return int|null
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }
    /**
     * Set policyId value
     * @param int $policyId
     * @return \App\Insis\StructType\ArchiveInfo
     */
    public function setPolicyId($policyId = null)
    {
        // validation for constraint: int
        if (!is_null($policyId) && !(is_int($policyId) || ctype_digit($policyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyId, true), gettype($policyId)), __LINE__);
        }
        $this->policyId = $policyId;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \App\Insis\StructType\ArchiveInfo
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
}
