<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for archive StructType
 * @subpackage Structs
 */
class Archive extends AbstractStructBase
{
    /**
     * The approvStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $approvStatus;
    /**
     * The archiveDocType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $archiveDocType;
    /**
     * The archiveId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $archiveId;
    /**
     * The archiveNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $archiveNo;
    /**
     * The archiveState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $archiveState;
    /**
     * The archiveType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $archiveType;
    /**
     * The changeUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $changeUserId;
    /**
     * The confirmatives
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ArchiveConfirmation[]
     */
    public $confirmatives;
    /**
     * The inputDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputDate;
    /**
     * The policies
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ArchivePolicyDetails[]
     */
    public $policies;
    /**
     * Constructor method for archive
     * @uses Archive::setApprovStatus()
     * @uses Archive::setArchiveDocType()
     * @uses Archive::setArchiveId()
     * @uses Archive::setArchiveNo()
     * @uses Archive::setArchiveState()
     * @uses Archive::setArchiveType()
     * @uses Archive::setChangeUserId()
     * @uses Archive::setConfirmatives()
     * @uses Archive::setInputDate()
     * @uses Archive::setPolicies()
     * @param string $approvStatus
     * @param string $archiveDocType
     * @param int $archiveId
     * @param string $archiveNo
     * @param int $archiveState
     * @param string $archiveType
     * @param int $changeUserId
     * @param \App\Insis\StructType\ArchiveConfirmation[] $confirmatives
     * @param string $inputDate
     * @param \App\Insis\StructType\ArchivePolicyDetails[] $policies
     */
    public function __construct($approvStatus = null, $archiveDocType = null, $archiveId = null, $archiveNo = null, $archiveState = null, $archiveType = null, $changeUserId = null, array $confirmatives = array(), $inputDate = null, array $policies = array())
    {
        $this
            ->setApprovStatus($approvStatus)
            ->setArchiveDocType($archiveDocType)
            ->setArchiveId($archiveId)
            ->setArchiveNo($archiveNo)
            ->setArchiveState($archiveState)
            ->setArchiveType($archiveType)
            ->setChangeUserId($changeUserId)
            ->setConfirmatives($confirmatives)
            ->setInputDate($inputDate)
            ->setPolicies($policies);
    }
    /**
     * Get approvStatus value
     * @return string|null
     */
    public function getApprovStatus()
    {
        return $this->approvStatus;
    }
    /**
     * Set approvStatus value
     * @param string $approvStatus
     * @return \App\Insis\StructType\Archive
     */
    public function setApprovStatus($approvStatus = null)
    {
        // validation for constraint: string
        if (!is_null($approvStatus) && !is_string($approvStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvStatus, true), gettype($approvStatus)), __LINE__);
        }
        $this->approvStatus = $approvStatus;
        return $this;
    }
    /**
     * Get archiveDocType value
     * @return string|null
     */
    public function getArchiveDocType()
    {
        return $this->archiveDocType;
    }
    /**
     * Set archiveDocType value
     * @param string $archiveDocType
     * @return \App\Insis\StructType\Archive
     */
    public function setArchiveDocType($archiveDocType = null)
    {
        // validation for constraint: string
        if (!is_null($archiveDocType) && !is_string($archiveDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveDocType, true), gettype($archiveDocType)), __LINE__);
        }
        $this->archiveDocType = $archiveDocType;
        return $this;
    }
    /**
     * Get archiveId value
     * @return int|null
     */
    public function getArchiveId()
    {
        return $this->archiveId;
    }
    /**
     * Set archiveId value
     * @param int $archiveId
     * @return \App\Insis\StructType\Archive
     */
    public function setArchiveId($archiveId = null)
    {
        // validation for constraint: int
        if (!is_null($archiveId) && !(is_int($archiveId) || ctype_digit($archiveId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($archiveId, true), gettype($archiveId)), __LINE__);
        }
        $this->archiveId = $archiveId;
        return $this;
    }
    /**
     * Get archiveNo value
     * @return string|null
     */
    public function getArchiveNo()
    {
        return $this->archiveNo;
    }
    /**
     * Set archiveNo value
     * @param string $archiveNo
     * @return \App\Insis\StructType\Archive
     */
    public function setArchiveNo($archiveNo = null)
    {
        // validation for constraint: string
        if (!is_null($archiveNo) && !is_string($archiveNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveNo, true), gettype($archiveNo)), __LINE__);
        }
        $this->archiveNo = $archiveNo;
        return $this;
    }
    /**
     * Get archiveState value
     * @return int|null
     */
    public function getArchiveState()
    {
        return $this->archiveState;
    }
    /**
     * Set archiveState value
     * @param int $archiveState
     * @return \App\Insis\StructType\Archive
     */
    public function setArchiveState($archiveState = null)
    {
        // validation for constraint: int
        if (!is_null($archiveState) && !(is_int($archiveState) || ctype_digit($archiveState))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($archiveState, true), gettype($archiveState)), __LINE__);
        }
        $this->archiveState = $archiveState;
        return $this;
    }
    /**
     * Get archiveType value
     * @return string|null
     */
    public function getArchiveType()
    {
        return $this->archiveType;
    }
    /**
     * Set archiveType value
     * @param string $archiveType
     * @return \App\Insis\StructType\Archive
     */
    public function setArchiveType($archiveType = null)
    {
        // validation for constraint: string
        if (!is_null($archiveType) && !is_string($archiveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveType, true), gettype($archiveType)), __LINE__);
        }
        $this->archiveType = $archiveType;
        return $this;
    }
    /**
     * Get changeUserId value
     * @return int|null
     */
    public function getChangeUserId()
    {
        return $this->changeUserId;
    }
    /**
     * Set changeUserId value
     * @param int $changeUserId
     * @return \App\Insis\StructType\Archive
     */
    public function setChangeUserId($changeUserId = null)
    {
        // validation for constraint: int
        if (!is_null($changeUserId) && !(is_int($changeUserId) || ctype_digit($changeUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($changeUserId, true), gettype($changeUserId)), __LINE__);
        }
        $this->changeUserId = $changeUserId;
        return $this;
    }
    /**
     * Get confirmatives value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ArchiveConfirmation[]|null
     */
    public function getConfirmatives()
    {
        return isset($this->confirmatives) ? $this->confirmatives : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConfirmatives method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfirmatives method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfirmativesForArrayConstraintsFromSetConfirmatives(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $archiveConfirmativesItem) {
            // validation for constraint: itemType
            if (!$archiveConfirmativesItem instanceof \App\Insis\StructType\ArchiveConfirmation) {
                $invalidValues[] = is_object($archiveConfirmativesItem) ? get_class($archiveConfirmativesItem) : sprintf('%s(%s)', gettype($archiveConfirmativesItem), var_export($archiveConfirmativesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The confirmatives property can only contain items of type \App\Insis\StructType\ArchiveConfirmation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set confirmatives value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ArchiveConfirmation[] $confirmatives
     * @return \App\Insis\StructType\Archive
     */
    public function setConfirmatives(array $confirmatives = array())
    {
        // validation for constraint: array
        if ('' !== ($confirmativesArrayErrorMessage = self::validateConfirmativesForArrayConstraintsFromSetConfirmatives($confirmatives))) {
            throw new \InvalidArgumentException($confirmativesArrayErrorMessage, __LINE__);
        }
        if (is_null($confirmatives) || (is_array($confirmatives) && empty($confirmatives))) {
            unset($this->confirmatives);
        } else {
            $this->confirmatives = $confirmatives;
        }
        return $this;
    }
    /**
     * Add item to confirmatives value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ArchiveConfirmation $item
     * @return \App\Insis\StructType\Archive
     */
    public function addToConfirmatives(\App\Insis\StructType\ArchiveConfirmation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ArchiveConfirmation) {
            throw new \InvalidArgumentException(sprintf('The confirmatives property can only contain items of type \App\Insis\StructType\ArchiveConfirmation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->confirmatives[] = $item;
        return $this;
    }
    /**
     * Get inputDate value
     * @return string|null
     */
    public function getInputDate()
    {
        return $this->inputDate;
    }
    /**
     * Set inputDate value
     * @param string $inputDate
     * @return \App\Insis\StructType\Archive
     */
    public function setInputDate($inputDate = null)
    {
        // validation for constraint: string
        if (!is_null($inputDate) && !is_string($inputDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputDate, true), gettype($inputDate)), __LINE__);
        }
        $this->inputDate = $inputDate;
        return $this;
    }
    /**
     * Get policies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ArchivePolicyDetails[]|null
     */
    public function getPolicies()
    {
        return isset($this->policies) ? $this->policies : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicies method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicies method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoliciesForArrayConstraintsFromSetPolicies(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $archivePoliciesItem) {
            // validation for constraint: itemType
            if (!$archivePoliciesItem instanceof \App\Insis\StructType\ArchivePolicyDetails) {
                $invalidValues[] = is_object($archivePoliciesItem) ? get_class($archivePoliciesItem) : sprintf('%s(%s)', gettype($archivePoliciesItem), var_export($archivePoliciesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The policies property can only contain items of type \App\Insis\StructType\ArchivePolicyDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ArchivePolicyDetails[] $policies
     * @return \App\Insis\StructType\Archive
     */
    public function setPolicies(array $policies = array())
    {
        // validation for constraint: array
        if ('' !== ($policiesArrayErrorMessage = self::validatePoliciesForArrayConstraintsFromSetPolicies($policies))) {
            throw new \InvalidArgumentException($policiesArrayErrorMessage, __LINE__);
        }
        if (is_null($policies) || (is_array($policies) && empty($policies))) {
            unset($this->policies);
        } else {
            $this->policies = $policies;
        }
        return $this;
    }
    /**
     * Add item to policies value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ArchivePolicyDetails $item
     * @return \App\Insis\StructType\Archive
     */
    public function addToPolicies(\App\Insis\StructType\ArchivePolicyDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ArchivePolicyDetails) {
            throw new \InvalidArgumentException(sprintf('The policies property can only contain items of type \App\Insis\StructType\ArchivePolicyDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->policies[] = $item;
        return $this;
    }
}
