<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Agent StructType
 * @subpackage Structs
 */
class Agent extends People
{
    /**
     * The agentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentNumber;
    /**
     * The officeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $officeID;
    /**
     * The employees
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $employees;
    /**
     * The codes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $codes;
    /**
     * The managerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $managerID;
    /**
     * The agentDocNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentDocNumber;
    /**
     * The agentDocDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentDocDate;
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The isActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $isActive;
    /**
     * The occupationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $occupationID;
    /**
     * The staffOccupationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $staffOccupationID;
    /**
     * The onlineChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $onlineChannel;
    /**
     * Constructor method for Agent
     * @uses Agent::setAgentNumber()
     * @uses Agent::setOfficeID()
     * @uses Agent::setEmployees()
     * @uses Agent::setCodes()
     * @uses Agent::setManagerID()
     * @uses Agent::setAgentDocNumber()
     * @uses Agent::setAgentDocDate()
     * @uses Agent::setBeginDate()
     * @uses Agent::setEndDate()
     * @uses Agent::setIsActive()
     * @uses Agent::setOccupationID()
     * @uses Agent::setStaffOccupationID()
     * @uses Agent::setOnlineChannel()
     * @param string $agentNumber
     * @param int $officeID
     * @param \App\Insis\StructType\ObjectParam[] $employees
     * @param \App\Insis\StructType\ObjectParam[] $codes
     * @param int $managerID
     * @param string $agentDocNumber
     * @param string $agentDocDate
     * @param string $beginDate
     * @param string $endDate
     * @param int $isActive
     * @param int $occupationID
     * @param int $staffOccupationID
     * @param int $onlineChannel
     */
    public function __construct($agentNumber = null, $officeID = null, array $employees = array(), array $codes = array(), $managerID = null, $agentDocNumber = null, $agentDocDate = null, $beginDate = null, $endDate = null, $isActive = null, $occupationID = null, $staffOccupationID = null, $onlineChannel = null)
    {
        $this
            ->setAgentNumber($agentNumber)
            ->setOfficeID($officeID)
            ->setEmployees($employees)
            ->setCodes($codes)
            ->setManagerID($managerID)
            ->setAgentDocNumber($agentDocNumber)
            ->setAgentDocDate($agentDocDate)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setIsActive($isActive)
            ->setOccupationID($occupationID)
            ->setStaffOccupationID($staffOccupationID)
            ->setOnlineChannel($onlineChannel);
    }
    /**
     * Get agentNumber value
     * @return string|null
     */
    public function getAgentNumber()
    {
        return $this->agentNumber;
    }
    /**
     * Set agentNumber value
     * @param string $agentNumber
     * @return \App\Insis\StructType\Agent
     */
    public function setAgentNumber($agentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agentNumber) && !is_string($agentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentNumber, true), gettype($agentNumber)), __LINE__);
        }
        $this->agentNumber = $agentNumber;
        return $this;
    }
    /**
     * Get officeID value
     * @return int|null
     */
    public function getOfficeID()
    {
        return $this->officeID;
    }
    /**
     * Set officeID value
     * @param int $officeID
     * @return \App\Insis\StructType\Agent
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: int
        if (!is_null($officeID) && !(is_int($officeID) || ctype_digit($officeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($officeID, true), gettype($officeID)), __LINE__);
        }
        $this->officeID = $officeID;
        return $this;
    }
    /**
     * Get employees value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getEmployees()
    {
        return $this->employees;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployees method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployees method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeesForArrayConstraintsFromSetEmployees(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agentEmployeesItem) {
            // validation for constraint: itemType
            if (!$agentEmployeesItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($agentEmployeesItem) ? get_class($agentEmployeesItem) : sprintf('%s(%s)', gettype($agentEmployeesItem), var_export($agentEmployeesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employees property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employees value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $employees
     * @return \App\Insis\StructType\Agent
     */
    public function setEmployees(array $employees = array())
    {
        // validation for constraint: array
        if ('' !== ($employeesArrayErrorMessage = self::validateEmployeesForArrayConstraintsFromSetEmployees($employees))) {
            throw new \InvalidArgumentException($employeesArrayErrorMessage, __LINE__);
        }
        $this->employees = $employees;
        return $this;
    }
    /**
     * Add item to employees value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Agent
     */
    public function addToEmployees(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The employees property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employees[] = $item;
        return $this;
    }
    /**
     * Get codes value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getCodes()
    {
        return $this->codes;
    }
    /**
     * This method is responsible for validating the values passed to the setCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodesForArrayConstraintsFromSetCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agentCodesItem) {
            // validation for constraint: itemType
            if (!$agentCodesItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($agentCodesItem) ? get_class($agentCodesItem) : sprintf('%s(%s)', gettype($agentCodesItem), var_export($agentCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The codes property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set codes value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $codes
     * @return \App\Insis\StructType\Agent
     */
    public function setCodes(array $codes = array())
    {
        // validation for constraint: array
        if ('' !== ($codesArrayErrorMessage = self::validateCodesForArrayConstraintsFromSetCodes($codes))) {
            throw new \InvalidArgumentException($codesArrayErrorMessage, __LINE__);
        }
        $this->codes = $codes;
        return $this;
    }
    /**
     * Add item to codes value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Agent
     */
    public function addToCodes(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The codes property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->codes[] = $item;
        return $this;
    }
    /**
     * Get managerID value
     * @return int|null
     */
    public function getManagerID()
    {
        return $this->managerID;
    }
    /**
     * Set managerID value
     * @param int $managerID
     * @return \App\Insis\StructType\Agent
     */
    public function setManagerID($managerID = null)
    {
        // validation for constraint: int
        if (!is_null($managerID) && !(is_int($managerID) || ctype_digit($managerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($managerID, true), gettype($managerID)), __LINE__);
        }
        $this->managerID = $managerID;
        return $this;
    }
    /**
     * Get agentDocNumber value
     * @return string|null
     */
    public function getAgentDocNumber()
    {
        return $this->agentDocNumber;
    }
    /**
     * Set agentDocNumber value
     * @param string $agentDocNumber
     * @return \App\Insis\StructType\Agent
     */
    public function setAgentDocNumber($agentDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($agentDocNumber) && !is_string($agentDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDocNumber, true), gettype($agentDocNumber)), __LINE__);
        }
        $this->agentDocNumber = $agentDocNumber;
        return $this;
    }
    /**
     * Get agentDocDate value
     * @return string|null
     */
    public function getAgentDocDate()
    {
        return $this->agentDocDate;
    }
    /**
     * Set agentDocDate value
     * @param string $agentDocDate
     * @return \App\Insis\StructType\Agent
     */
    public function setAgentDocDate($agentDocDate = null)
    {
        // validation for constraint: string
        if (!is_null($agentDocDate) && !is_string($agentDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDocDate, true), gettype($agentDocDate)), __LINE__);
        }
        $this->agentDocDate = $agentDocDate;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\Agent
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\Agent
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get isActive value
     * @return int|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param int $isActive
     * @return \App\Insis\StructType\Agent
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: int
        if (!is_null($isActive) && !(is_int($isActive) || ctype_digit($isActive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get occupationID value
     * @return int|null
     */
    public function getOccupationID()
    {
        return $this->occupationID;
    }
    /**
     * Set occupationID value
     * @param int $occupationID
     * @return \App\Insis\StructType\Agent
     */
    public function setOccupationID($occupationID = null)
    {
        // validation for constraint: int
        if (!is_null($occupationID) && !(is_int($occupationID) || ctype_digit($occupationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupationID, true), gettype($occupationID)), __LINE__);
        }
        $this->occupationID = $occupationID;
        return $this;
    }
    /**
     * Get staffOccupationID value
     * @return int|null
     */
    public function getStaffOccupationID()
    {
        return $this->staffOccupationID;
    }
    /**
     * Set staffOccupationID value
     * @param int $staffOccupationID
     * @return \App\Insis\StructType\Agent
     */
    public function setStaffOccupationID($staffOccupationID = null)
    {
        // validation for constraint: int
        if (!is_null($staffOccupationID) && !(is_int($staffOccupationID) || ctype_digit($staffOccupationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staffOccupationID, true), gettype($staffOccupationID)), __LINE__);
        }
        $this->staffOccupationID = $staffOccupationID;
        return $this;
    }
    /**
     * Get onlineChannel value
     * @return int|null
     */
    public function getOnlineChannel()
    {
        return $this->onlineChannel;
    }
    /**
     * Set onlineChannel value
     * @param int $onlineChannel
     * @return \App\Insis\StructType\Agent
     */
    public function setOnlineChannel($onlineChannel = null)
    {
        // validation for constraint: int
        if (!is_null($onlineChannel) && !(is_int($onlineChannel) || ctype_digit($onlineChannel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineChannel, true), gettype($onlineChannel)), __LINE__);
        }
        $this->onlineChannel = $onlineChannel;
        return $this;
    }
}
