<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The addressType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressType;
    /**
     * The apartmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apartmentNumber;
    /**
     * The blockNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blockNumber;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $region;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The streetName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $streetName;
    /**
     * Constructor method for address
     * @uses Address::setAddressType()
     * @uses Address::setApartmentNumber()
     * @uses Address::setBlockNumber()
     * @uses Address::setCity()
     * @uses Address::setCountry()
     * @uses Address::setRegion()
     * @uses Address::setState()
     * @uses Address::setStreetName()
     * @param string $addressType
     * @param string $apartmentNumber
     * @param string $blockNumber
     * @param int $city
     * @param string $country
     * @param int $region
     * @param string $state
     * @param string $streetName
     */
    public function __construct($addressType = null, $apartmentNumber = null, $blockNumber = null, $city = null, $country = null, $region = null, $state = null, $streetName = null)
    {
        $this
            ->setAddressType($addressType)
            ->setApartmentNumber($apartmentNumber)
            ->setBlockNumber($blockNumber)
            ->setCity($city)
            ->setCountry($country)
            ->setRegion($region)
            ->setState($state)
            ->setStreetName($streetName);
    }
    /**
     * Get addressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->addressType;
    }
    /**
     * Set addressType value
     * @param string $addressType
     * @return \App\Insis\StructType\Address
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressType, true), gettype($addressType)), __LINE__);
        }
        $this->addressType = $addressType;
        return $this;
    }
    /**
     * Get apartmentNumber value
     * @return string|null
     */
    public function getApartmentNumber()
    {
        return $this->apartmentNumber;
    }
    /**
     * Set apartmentNumber value
     * @param string $apartmentNumber
     * @return \App\Insis\StructType\Address
     */
    public function setApartmentNumber($apartmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($apartmentNumber) && !is_string($apartmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apartmentNumber, true), gettype($apartmentNumber)), __LINE__);
        }
        $this->apartmentNumber = $apartmentNumber;
        return $this;
    }
    /**
     * Get blockNumber value
     * @return string|null
     */
    public function getBlockNumber()
    {
        return $this->blockNumber;
    }
    /**
     * Set blockNumber value
     * @param string $blockNumber
     * @return \App\Insis\StructType\Address
     */
    public function setBlockNumber($blockNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blockNumber) && !is_string($blockNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockNumber, true), gettype($blockNumber)), __LINE__);
        }
        $this->blockNumber = $blockNumber;
        return $this;
    }
    /**
     * Get city value
     * @return int|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param int $city
     * @return \App\Insis\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: int
        if (!is_null($city) && !(is_int($city) || ctype_digit($city))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \App\Insis\StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get region value
     * @return int|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param int $region
     * @return \App\Insis\StructType\Address
     */
    public function setRegion($region = null)
    {
        // validation for constraint: int
        if (!is_null($region) && !(is_int($region) || ctype_digit($region))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \App\Insis\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \App\Insis\StructType\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
}
