<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sey ServiceType
 * @subpackage Services
 */
class Sey extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named seyHello
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SeyHello $parameters
     * @return \App\Insis\StructType\SeyHelloResponse|bool
     */
    public function seyHello(\App\Insis\StructType\SeyHello $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seyHello($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\SeyHelloResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
