<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPolicy $parameters
     * @return \App\Insis\StructType\SetPolicyResponse|bool
     */
    public function setPolicy(\App\Insis\StructType\SetPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetApplication $parameters
     * @return \App\Insis\StructType\SetApplicationResponse|bool
     */
    public function setApplication(\App\Insis\StructType\SetApplication $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetArchive $parameters
     * @return \App\Insis\StructType\SetArchiveResponse|bool
     */
    public function setArchive(\App\Insis\StructType\SetArchive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setArchive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCallCenterSale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetCallCenterSale $parameters
     * @return \App\Insis\StructType\SetCallCenterSaleResponse|bool
     */
    public function setCallCenterSale(\App\Insis\StructType\SetCallCenterSale $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setCallCenterSale($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCash
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetCash $parameters
     * @return \App\Insis\StructType\SetCashResponse|bool
     */
    public function setCash(\App\Insis\StructType\SetCash $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setCash($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPayment $parameters
     * @return \App\Insis\StructType\SetPaymentResponse|bool
     */
    public function setPayment(\App\Insis\StructType\SetPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetObjectCar $parameters
     * @return \App\Insis\StructType\SetObjectCarResponse|bool
     */
    public function setObjectCar(\App\Insis\StructType\SetObjectCar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBlanks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetBlanks $parameters
     * @return \App\Insis\StructType\SetBlanksResponse|bool
     */
    public function setBlanks(\App\Insis\StructType\SetBlanks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setBlanks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setAMEXPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetAMEXPolicy $parameters
     * @return \App\Insis\StructType\SetAMEXPolicyResponse|bool
     */
    public function setAMEXPolicy(\App\Insis\StructType\SetAMEXPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setAMEXPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setOSRNSDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetOSRNSDetails $parameters
     * @return \App\Insis\StructType\SetOSRNSDetailsResponse|bool
     */
    public function setOSRNSDetails(\App\Insis\StructType\SetOSRNSDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setOSRNSDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPolicyAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPolicyAttachment $parameters
     * @return \App\Insis\StructType\SetPolicyAttachmentResponse|bool
     */
    public function setPolicyAttachment(\App\Insis\StructType\SetPolicyAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPolicyAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setIncomingReinsurance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetIncomingReinsurance $parameters
     * @return \App\Insis\StructType\SetIncomingReinsuranceResponse|bool
     */
    public function setIncomingReinsurance(\App\Insis\StructType\SetIncomingReinsurance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setIncomingReinsurance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setArchiveConfirm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetArchiveConfirm $parameters
     * @return \App\Insis\StructType\SetArchiveConfirmResponse|bool
     */
    public function setArchiveConfirm(\App\Insis\StructType\SetArchiveConfirm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setArchiveConfirm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectLiability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetObjectLiability $parameters
     * @return \App\Insis\StructType\SetObjectLiabilityResponse|bool
     */
    public function setObjectLiability(\App\Insis\StructType\SetObjectLiability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectLiability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetObjectProperty $parameters
     * @return \App\Insis\StructType\SetObjectPropertyResponse|bool
     */
    public function setObjectProperty(\App\Insis\StructType\SetObjectProperty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCargo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetObjectCargo $parameters
     * @return \App\Insis\StructType\SetObjectCargoResponse|bool
     */
    public function setObjectCargo(\App\Insis\StructType\SetObjectCargo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCargo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPeople $parameters
     * @return \App\Insis\StructType\SetPeopleResponse|bool
     */
    public function setPeople(\App\Insis\StructType\SetPeople $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPeople($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setSiebelHBCardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetSiebelHBCardInfo $parameters
     * @return \App\Insis\StructType\SetSiebelHBCardInfoResponse|bool
     */
    public function setSiebelHBCardInfo(\App\Insis\StructType\SetSiebelHBCardInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setSiebelHBCardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setSiebelBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetSiebelBoxPayment $parameters
     * @return \App\Insis\StructType\SetSiebelBoxPaymentResponse|bool
     */
    public function setSiebelBoxPayment(\App\Insis\StructType\SetSiebelBoxPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setSiebelBoxPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setSiebelPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetSiebelPolicy $parameters
     * @return \App\Insis\StructType\SetSiebelPolicyResponse|bool
     */
    public function setSiebelPolicy(\App\Insis\StructType\SetSiebelPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setSiebelPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCustom
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetObjectCustom $parameters
     * @return \App\Insis\StructType\SetObjectCustomResponse|bool
     */
    public function setObjectCustom(\App\Insis\StructType\SetObjectCustom $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCustom($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetBoxAddress $parameters
     * @return \App\Insis\StructType\SetBoxAddressResponse|bool
     */
    public function setBoxAddress(\App\Insis\StructType\SetBoxAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRequestData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetRequestData $parameters
     * @return \App\Insis\StructType\SetRequestDataResponse|bool
     */
    public function setRequestData(\App\Insis\StructType\SetRequestData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setRequestData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetBoxPayment $parameters
     * @return \App\Insis\StructType\SetBoxPaymentResponse|bool
     */
    public function setBoxPayment(\App\Insis\StructType\SetBoxPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRequestDataFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetRequestDataFile $parameters
     * @return \App\Insis\StructType\SetRequestDataFileResponse|bool
     */
    public function setRequestDataFile(\App\Insis\StructType\SetRequestDataFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setRequestDataFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPolicyOGPOAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPolicyOGPOAuto $parameters
     * @return \App\Insis\StructType\SetPolicyOGPOAutoResponse|bool
     */
    public function setPolicyOGPOAuto(\App\Insis\StructType\SetPolicyOGPOAuto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPolicyOGPOAuto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetBoxPayments $parameters
     * @return \App\Insis\StructType\SetBoxPaymentsResponse|bool
     */
    public function setBoxPayments(\App\Insis\StructType\SetBoxPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPaymentReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPaymentReference $parameters
     * @return \App\Insis\StructType\SetPaymentReferenceResponse|bool
     */
    public function setPaymentReference(\App\Insis\StructType\SetPaymentReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPaymentReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setTravelPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetTravelPolicy $parameters
     * @return \App\Insis\StructType\SetTravelPolicyResponse|bool
     */
    public function setTravelPolicy(\App\Insis\StructType\SetTravelPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setTravelPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setVerifiedPeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetVerifiedPeople $parameters
     * @return \App\Insis\StructType\SetVerifiedPeopleResponse|bool
     */
    public function setVerifiedPeople(\App\Insis\StructType\SetVerifiedPeople $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setVerifiedPeople($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCarAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetObjectCarAttachment $parameters
     * @return \App\Insis\StructType\SetObjectCarAttachmentResponse|bool
     */
    public function setObjectCarAttachment(\App\Insis\StructType\SetObjectCarAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCarAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setErrorText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetErrorText $parameters
     * @return \App\Insis\StructType\SetErrorTextResponse|bool
     */
    public function setErrorText(\App\Insis\StructType\SetErrorText $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setErrorText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPaymentSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetPaymentSite $parameters
     * @return \App\Insis\StructType\SetPaymentSiteResponse|bool
     */
    public function setPaymentSite(\App\Insis\StructType\SetPaymentSite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setPaymentSite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxAddressKATO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetBoxAddressKATO $parameters
     * @return \App\Insis\StructType\SetBoxAddressKATOResponse|bool
     */
    public function setBoxAddressKATO(\App\Insis\StructType\SetBoxAddressKATO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxAddressKATO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setHalykTravel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetHalykTravel $parameters
     * @return \App\Insis\StructType\SetHalykTravelResponse|bool
     */
    public function setHalykTravel(\App\Insis\StructType\SetHalykTravel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setHalykTravel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setHalykTravelPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetHalykTravelPayment $parameters
     * @return \App\Insis\StructType\SetHalykTravelPaymentResponse|bool
     */
    public function setHalykTravelPayment(\App\Insis\StructType\SetHalykTravelPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setHalykTravelPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setClaimInfoAttach
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SetClaimInfoAttach $parameters
     * @return \App\Insis\StructType\SetClaimInfoAttachResponse|bool
     */
    public function setClaimInfoAttach(\App\Insis\StructType\SetClaimInfoAttach $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setClaimInfoAttach($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\SetAMEXPolicyResponse|\App\Insis\StructType\SetApplicationResponse|\App\Insis\StructType\SetArchiveConfirmResponse|\App\Insis\StructType\SetArchiveResponse|\App\Insis\StructType\SetBlanksResponse|\App\Insis\StructType\SetBoxAddressKATOResponse|\App\Insis\StructType\SetBoxAddressResponse|\App\Insis\StructType\SetBoxPaymentResponse|\App\Insis\StructType\SetBoxPaymentsResponse|\App\Insis\StructType\SetCallCenterSaleResponse|\App\Insis\StructType\SetCashResponse|\App\Insis\StructType\SetClaimInfoAttachResponse|\App\Insis\StructType\SetErrorTextResponse|\App\Insis\StructType\SetHalykTravelPaymentResponse|\App\Insis\StructType\SetHalykTravelResponse|\App\Insis\StructType\SetIncomingReinsuranceResponse|\App\Insis\StructType\SetObjectCarAttachmentResponse|\App\Insis\StructType\SetObjectCargoResponse|\App\Insis\StructType\SetObjectCarResponse|\App\Insis\StructType\SetObjectCustomResponse|\App\Insis\StructType\SetObjectLiabilityResponse|\App\Insis\StructType\SetObjectPropertyResponse|\App\Insis\StructType\SetOSRNSDetailsResponse|\App\Insis\StructType\SetPaymentReferenceResponse|\App\Insis\StructType\SetPaymentResponse|\App\Insis\StructType\SetPaymentSiteResponse|\App\Insis\StructType\SetPeopleResponse|\App\Insis\StructType\SetPolicyAttachmentResponse|\App\Insis\StructType\SetPolicyOGPOAutoResponse|\App\Insis\StructType\SetPolicyResponse|\App\Insis\StructType\SetRequestDataFileResponse|\App\Insis\StructType\SetRequestDataResponse|\App\Insis\StructType\SetSiebelBoxPaymentResponse|\App\Insis\StructType\SetSiebelHBCardInfoResponse|\App\Insis\StructType\SetSiebelPolicyResponse|\App\Insis\StructType\SetTravelPolicyResponse|\App\Insis\StructType\SetVerifiedPeopleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
