<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendPrintFormToEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SendPrintFormToEmail $parameters
     * @return \App\Insis\StructType\SendPrintFormToEmailResponse|bool
     */
    public function sendPrintFormToEmail(\App\Insis\StructType\SendPrintFormToEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendPrintFormToEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendTestMailForMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SendTestMailForMe $parameters
     * @return \App\Insis\StructType\SendTestMailForMeResponse|bool
     */
    public function sendTestMailForMe(\App\Insis\StructType\SendTestMailForMe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendTestMailForMe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSmsOil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SendSmsOil $parameters
     * @return \App\Insis\StructType\SendSmsOilResponse|bool
     */
    public function sendSmsOil(\App\Insis\StructType\SendSmsOil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSmsOil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSmsTechInspection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SendSmsTechInspection $parameters
     * @return \App\Insis\StructType\SendSmsTechInspectionResponse|bool
     */
    public function sendSmsTechInspection(\App\Insis\StructType\SendSmsTechInspection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSmsTechInspection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendPrintFormToEmailIPTest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\SendPrintFormToEmailIPTest $parameters
     * @return \App\Insis\StructType\SendPrintFormToEmailIPTestResponse|bool
     */
    public function sendPrintFormToEmailIPTest(\App\Insis\StructType\SendPrintFormToEmailIPTest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendPrintFormToEmailIPTest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\SendPrintFormToEmailIPTestResponse|\App\Insis\StructType\SendPrintFormToEmailResponse|\App\Insis\StructType\SendSmsOilResponse|\App\Insis\StructType\SendSmsTechInspectionResponse|\App\Insis\StructType\SendTestMailForMeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
