<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Renewal ServiceType
 * @subpackage Services
 */
class Renewal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named renewalPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\RenewalPolicy $parameters
     * @return \App\Insis\StructType\RenewalPolicyResponse|bool
     */
    public function renewalPolicy(\App\Insis\StructType\RenewalPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->renewalPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\RenewalPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
