<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Merge ServiceType
 * @subpackage Services
 */
class Merge extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mergeSiebelBoxClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\MergeSiebelBoxClient $parameters
     * @return \App\Insis\StructType\MergeSiebelBoxClientResponse|bool
     */
    public function mergeSiebelBoxClient(\App\Insis\StructType\MergeSiebelBoxClient $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mergeSiebelBoxClient($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\MergeSiebelBoxClientResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
