<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\DeleteBill $parameters
     * @return \App\Insis\StructType\DeleteBillResponse|bool
     */
    public function deleteBill(\App\Insis\StructType\DeleteBill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteBill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\DeleteArchive $parameters
     * @return \App\Insis\StructType\DeleteArchiveResponse|bool
     */
    public function deleteArchive(\App\Insis\StructType\DeleteArchive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteArchive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteDocumentAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\DeleteDocumentAttachment $parameters
     * @return \App\Insis\StructType\DeleteDocumentAttachmentResponse|bool
     */
    public function deleteDocumentAttachment(\App\Insis\StructType\DeleteDocumentAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteDocumentAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\DeleteArchiveResponse|\App\Insis\StructType\DeleteBillResponse|\App\Insis\StructType\DeleteDocumentAttachmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
