<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CreateBill $parameters
     * @return \App\Insis\StructType\CreateBillResponse|bool
     */
    public function createBill(\App\Insis\StructType\CreateBill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createBill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createSiebelBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CreateSiebelBox $parameters
     * @return \App\Insis\StructType\CreateSiebelBoxResponse|bool
     */
    public function createSiebelBox(\App\Insis\StructType\CreateSiebelBox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createSiebelBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\CreateBillResponse|\App\Insis\StructType\CreateSiebelBoxResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
