<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @subpackage Services
 */
class Convert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named convertPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\ConvertPolicy $parameters
     * @return \App\Insis\StructType\ConvertPolicyResponse|bool
     */
    public function convertPolicy(\App\Insis\StructType\ConvertPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->convertPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\ConvertPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
