<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clean ServiceType
 * @subpackage Services
 */
class Clean extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cleanQueue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CleanQueue $parameters
     * @return \App\Insis\StructType\CleanQueueResponse|bool
     */
    public function cleanQueue(\App\Insis\StructType\CleanQueue $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cleanQueue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\CleanQueueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
