<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calc ServiceType
 * @subpackage Services
 */
class Calc extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named calcOsgpoAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcOsgpoAuto $parameters
     * @return \App\Insis\StructType\CalcOsgpoAutoResponse|bool
     */
    public function calcOsgpoAuto(\App\Insis\StructType\CalcOsgpoAuto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcOsgpoAuto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcOsgpoAutoCalendar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcOsgpoAutoCalendar $parameters
     * @return \App\Insis\StructType\CalcOsgpoAutoCalendarResponse|bool
     */
    public function calcOsgpoAutoCalendar(\App\Insis\StructType\CalcOsgpoAutoCalendar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcOsgpoAutoCalendar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcMst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcMst $parameters
     * @return \App\Insis\StructType\CalcMstResponse|bool
     */
    public function calcMst(\App\Insis\StructType\CalcMst $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcMst($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcOp_onai
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcOp_onai $parameters
     * @return \App\Insis\StructType\CalcOp_onaiResponse|bool
     */
    public function calcOp_onai(\App\Insis\StructType\CalcOp_onai $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcOp_onai($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcCascoClassic
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcCascoClassic $parameters
     * @return \App\Insis\StructType\CalcCascoClassicResponse|bool
     */
    public function calcCascoClassic(\App\Insis\StructType\CalcCascoClassic $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcCascoClassic($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcCascoAvangard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcCascoAvangard $parameters
     * @return \App\Insis\StructType\CalcCascoAvangardResponse|bool
     */
    public function calcCascoAvangard(\App\Insis\StructType\CalcCascoAvangard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcCascoAvangard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcCascoEleganse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CalcCascoEleganse $parameters
     * @return \App\Insis\StructType\CalcCascoEleganseResponse|bool
     */
    public function calcCascoEleganse(\App\Insis\StructType\CalcCascoEleganse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calcCascoEleganse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\CalcCascoAvangardResponse|\App\Insis\StructType\CalcCascoClassicResponse|\App\Insis\StructType\CalcCascoEleganseResponse|\App\Insis\StructType\CalcMstResponse|\App\Insis\StructType\CalcOp_onaiResponse|\App\Insis\StructType\CalcOsgpoAutoCalendarResponse|\App\Insis\StructType\CalcOsgpoAutoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
