<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Active ServiceType
 * @subpackage Services
 */
class Active extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named activeTechInspection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\ActiveTechInspection $parameters
     * @return \App\Insis\StructType\ActiveTechInspectionResponse|bool
     */
    public function activeTechInspection(\App\Insis\StructType\ActiveTechInspection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->activeTechInspection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\ActiveTechInspectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
