<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Activate ServiceType
 * @subpackage Services
 */
class Activate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named activateBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\ActivateBox $parameters
     * @return \App\Insis\StructType\ActivateBoxResponse|bool
     */
    public function activateBox(\App\Insis\StructType\ActivateBox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->activateBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\ActivateBoxResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
