<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for APIT ServiceType
 * @subpackage Services
 */
class APIT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named APITest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\APITest $parameters
     * @return \App\Insis\StructType\APITestResponse|bool
     */
    public function APITest(\App\Insis\StructType\APITest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->APITest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\APITestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
