<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tariff StructType
 * @subpackage Structs
 */
class Tariff extends AbstractStructBase
{
    /**
     * The tariffTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffTypeID;
    /**
     * The tariffValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tariffValue;
    /**
     * The agentCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $agentCommission;
    /**
     * Constructor method for Tariff
     * @uses Tariff::setTariffTypeID()
     * @uses Tariff::setTariffValue()
     * @uses Tariff::setAgentCommission()
     * @param string $tariffTypeID
     * @param float $tariffValue
     * @param float $agentCommission
     */
    public function __construct($tariffTypeID = null, $tariffValue = null, $agentCommission = null)
    {
        $this
            ->setTariffTypeID($tariffTypeID)
            ->setTariffValue($tariffValue)
            ->setAgentCommission($agentCommission);
    }
    /**
     * Get tariffTypeID value
     * @return string|null
     */
    public function getTariffTypeID()
    {
        return $this->tariffTypeID;
    }
    /**
     * Set tariffTypeID value
     * @param string $tariffTypeID
     * @return \App\Insis\StructType\Tariff
     */
    public function setTariffTypeID($tariffTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($tariffTypeID) && !is_string($tariffTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffTypeID, true), gettype($tariffTypeID)), __LINE__);
        }
        $this->tariffTypeID = $tariffTypeID;
        return $this;
    }
    /**
     * Get tariffValue value
     * @return float|null
     */
    public function getTariffValue()
    {
        return $this->tariffValue;
    }
    /**
     * Set tariffValue value
     * @param float $tariffValue
     * @return \App\Insis\StructType\Tariff
     */
    public function setTariffValue($tariffValue = null)
    {
        // validation for constraint: float
        if (!is_null($tariffValue) && !(is_float($tariffValue) || is_numeric($tariffValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tariffValue, true), gettype($tariffValue)), __LINE__);
        }
        $this->tariffValue = $tariffValue;
        return $this;
    }
    /**
     * Get agentCommission value
     * @return float|null
     */
    public function getAgentCommission()
    {
        return $this->agentCommission;
    }
    /**
     * Set agentCommission value
     * @param float $agentCommission
     * @return \App\Insis\StructType\Tariff
     */
    public function setAgentCommission($agentCommission = null)
    {
        // validation for constraint: float
        if (!is_null($agentCommission) && !(is_float($agentCommission) || is_numeric($agentCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agentCommission, true), gettype($agentCommission)), __LINE__);
        }
        $this->agentCommission = $agentCommission;
        return $this;
    }
}
