<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for staff StructType
 * @subpackage Structs
 */
class Staff extends People
{
    /**
     * The employees
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $employees;
    /**
     * The occupationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $occupationID;
    /**
     * Constructor method for staff
     * @uses Staff::setEmployees()
     * @uses Staff::setOccupationID()
     * @param \App\Insis\StructType\ObjectParam[] $employees
     * @param int $occupationID
     */
    public function __construct(array $employees = array(), $occupationID = null)
    {
        $this
            ->setEmployees($employees)
            ->setOccupationID($occupationID);
    }
    /**
     * Get employees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getEmployees()
    {
        return isset($this->employees) ? $this->employees : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployees method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployees method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeesForArrayConstraintsFromSetEmployees(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $staffEmployeesItem) {
            // validation for constraint: itemType
            if (!$staffEmployeesItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($staffEmployeesItem) ? get_class($staffEmployeesItem) : sprintf('%s(%s)', gettype($staffEmployeesItem), var_export($staffEmployeesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employees property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $employees
     * @return \App\Insis\StructType\Staff
     */
    public function setEmployees(array $employees = array())
    {
        // validation for constraint: array
        if ('' !== ($employeesArrayErrorMessage = self::validateEmployeesForArrayConstraintsFromSetEmployees($employees))) {
            throw new \InvalidArgumentException($employeesArrayErrorMessage, __LINE__);
        }
        if (is_null($employees) || (is_array($employees) && empty($employees))) {
            unset($this->employees);
        } else {
            $this->employees = $employees;
        }
        return $this;
    }
    /**
     * Add item to employees value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Staff
     */
    public function addToEmployees(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The employees property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employees[] = $item;
        return $this;
    }
    /**
     * Get occupationID value
     * @return int|null
     */
    public function getOccupationID()
    {
        return $this->occupationID;
    }
    /**
     * Set occupationID value
     * @param int $occupationID
     * @return \App\Insis\StructType\Staff
     */
    public function setOccupationID($occupationID = null)
    {
        // validation for constraint: int
        if (!is_null($occupationID) && !(is_int($occupationID) || ctype_digit($occupationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupationID, true), gettype($occupationID)), __LINE__);
        }
        $this->occupationID = $occupationID;
        return $this;
    }
}
