<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelRisk StructType
 * @subpackage Structs
 */
class SiebelRisk extends AbstractStructBase
{
    /**
     * The activ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activ;
    /**
     * The events
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelEvents[]
     */
    public $events;
    /**
     * The franschise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $franschise;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $limit;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for siebelRisk
     * @uses SiebelRisk::setActiv()
     * @uses SiebelRisk::setEvents()
     * @uses SiebelRisk::setFranschise()
     * @uses SiebelRisk::setLimit()
     * @uses SiebelRisk::setName()
     * @param string $activ
     * @param \App\Insis\StructType\SiebelEvents[] $events
     * @param string $franschise
     * @param string $limit
     * @param string $name
     */
    public function __construct($activ = null, array $events = array(), $franschise = null, $limit = null, $name = null)
    {
        $this
            ->setActiv($activ)
            ->setEvents($events)
            ->setFranschise($franschise)
            ->setLimit($limit)
            ->setName($name);
    }
    /**
     * Get activ value
     * @return string|null
     */
    public function getActiv()
    {
        return $this->activ;
    }
    /**
     * Set activ value
     * @param string $activ
     * @return \App\Insis\StructType\SiebelRisk
     */
    public function setActiv($activ = null)
    {
        // validation for constraint: string
        if (!is_null($activ) && !is_string($activ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activ, true), gettype($activ)), __LINE__);
        }
        $this->activ = $activ;
        return $this;
    }
    /**
     * Get events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelEvents[]|null
     */
    public function getEvents()
    {
        return isset($this->events) ? $this->events : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventsForArrayConstraintsFromSetEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelRiskEventsItem) {
            // validation for constraint: itemType
            if (!$siebelRiskEventsItem instanceof \App\Insis\StructType\SiebelEvents) {
                $invalidValues[] = is_object($siebelRiskEventsItem) ? get_class($siebelRiskEventsItem) : sprintf('%s(%s)', gettype($siebelRiskEventsItem), var_export($siebelRiskEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The events property can only contain items of type \App\Insis\StructType\SiebelEvents, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelEvents[] $events
     * @return \App\Insis\StructType\SiebelRisk
     */
    public function setEvents(array $events = array())
    {
        // validation for constraint: array
        if ('' !== ($eventsArrayErrorMessage = self::validateEventsForArrayConstraintsFromSetEvents($events))) {
            throw new \InvalidArgumentException($eventsArrayErrorMessage, __LINE__);
        }
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->events);
        } else {
            $this->events = $events;
        }
        return $this;
    }
    /**
     * Add item to events value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelEvents $item
     * @return \App\Insis\StructType\SiebelRisk
     */
    public function addToEvents(\App\Insis\StructType\SiebelEvents $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelEvents) {
            throw new \InvalidArgumentException(sprintf('The events property can only contain items of type \App\Insis\StructType\SiebelEvents, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->events[] = $item;
        return $this;
    }
    /**
     * Get franschise value
     * @return string|null
     */
    public function getFranschise()
    {
        return $this->franschise;
    }
    /**
     * Set franschise value
     * @param string $franschise
     * @return \App\Insis\StructType\SiebelRisk
     */
    public function setFranschise($franschise = null)
    {
        // validation for constraint: string
        if (!is_null($franschise) && !is_string($franschise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franschise, true), gettype($franschise)), __LINE__);
        }
        $this->franschise = $franschise;
        return $this;
    }
    /**
     * Get limit value
     * @return string|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param string $limit
     * @return \App\Insis\StructType\SiebelRisk
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: string
        if (!is_null($limit) && !is_string($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Insis\StructType\SiebelRisk
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
