<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelPolicy StructType
 * @subpackage Structs
 */
class SiebelPolicy extends AbstractStructBase
{
    /**
     * The agent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agent;
    /**
     * The beneficiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelBeneficiary[]
     */
    public $beneficiary;
    /**
     * The bonusDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bonusDesc;
    /**
     * The bonusPerc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bonusPerc;
    /**
     * The comPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comPercent;
    /**
     * The comPersentMax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $comPersentMax;
    /**
     * The comPersentMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $comPersentMin;
    /**
     * The comRateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comRateType;
    /**
     * The comSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comSum;
    /**
     * The conditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $conditions;
    /**
     * The creditDocDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creditDocDate;
    /**
     * The creditDocNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creditDocNum;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The currencyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currencyRate;
    /**
     * The dateEndProtection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEndProtection;
    /**
     * The dateStartProtection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateStartProtection;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The discountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $discountPercent;
    /**
     * The discountReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountReason;
    /**
     * The ESBDId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ESBDId;
    /**
     * The franchise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $franchise;
    /**
     * The franchiseConditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $franchiseConditions;
    /**
     * The franchisePerc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $franchisePerc;
    /**
     * The franchiseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $franchiseType;
    /**
     * The guarantlyDocNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $guarantlyDocNum;
    /**
     * The insPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insPlace;
    /**
     * The insPrem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insPrem;
    /**
     * The insSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insSum;
    /**
     * The insTerritory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insTerritory;
    /**
     * The insurer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelInsurer[]
     */
    public $insurer;
    /**
     * The manager
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manager;
    /**
     * The numBasicPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numBasicPolicy;
    /**
     * The numGenPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numGenPolicy;
    /**
     * The numPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numPolicy;
    /**
     * The object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelObject[]
     */
    public $object;
    /**
     * The ownRetention
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ownRetention;
    /**
     * The paymentFact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelPaymentFact[]
     */
    public $paymentFact;
    /**
     * The paymentPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelPaymentPlan[]
     */
    public $paymentPlan;
    /**
     * The policyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyDate;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The promotion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $promotion;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The realizationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $realizationChannel;
    /**
     * The realizationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $realizationDetails;
    /**
     * The siebelPaymentOffset
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelPaymentOffset[]
     */
    public $siebelPaymentOffset;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for siebelPolicy
     * @uses SiebelPolicy::setAgent()
     * @uses SiebelPolicy::setBeneficiary()
     * @uses SiebelPolicy::setBonusDesc()
     * @uses SiebelPolicy::setBonusPerc()
     * @uses SiebelPolicy::setComPercent()
     * @uses SiebelPolicy::setComPersentMax()
     * @uses SiebelPolicy::setComPersentMin()
     * @uses SiebelPolicy::setComRateType()
     * @uses SiebelPolicy::setComSum()
     * @uses SiebelPolicy::setConditions()
     * @uses SiebelPolicy::setCreditDocDate()
     * @uses SiebelPolicy::setCreditDocNum()
     * @uses SiebelPolicy::setCurrency()
     * @uses SiebelPolicy::setCurrencyRate()
     * @uses SiebelPolicy::setDateEndProtection()
     * @uses SiebelPolicy::setDateStartProtection()
     * @uses SiebelPolicy::setDescription()
     * @uses SiebelPolicy::setDiscountPercent()
     * @uses SiebelPolicy::setDiscountReason()
     * @uses SiebelPolicy::setESBDId()
     * @uses SiebelPolicy::setFranchise()
     * @uses SiebelPolicy::setFranchiseConditions()
     * @uses SiebelPolicy::setFranchisePerc()
     * @uses SiebelPolicy::setFranchiseType()
     * @uses SiebelPolicy::setGuarantlyDocNum()
     * @uses SiebelPolicy::setInsPlace()
     * @uses SiebelPolicy::setInsPrem()
     * @uses SiebelPolicy::setInsSum()
     * @uses SiebelPolicy::setInsTerritory()
     * @uses SiebelPolicy::setInsurer()
     * @uses SiebelPolicy::setManager()
     * @uses SiebelPolicy::setNumBasicPolicy()
     * @uses SiebelPolicy::setNumGenPolicy()
     * @uses SiebelPolicy::setNumPolicy()
     * @uses SiebelPolicy::setObject()
     * @uses SiebelPolicy::setOwnRetention()
     * @uses SiebelPolicy::setPaymentFact()
     * @uses SiebelPolicy::setPaymentPlan()
     * @uses SiebelPolicy::setPolicyDate()
     * @uses SiebelPolicy::setProduct()
     * @uses SiebelPolicy::setPromotion()
     * @uses SiebelPolicy::setRate()
     * @uses SiebelPolicy::setRealizationChannel()
     * @uses SiebelPolicy::setRealizationDetails()
     * @uses SiebelPolicy::setSiebelPaymentOffset()
     * @uses SiebelPolicy::setStatus()
     * @uses SiebelPolicy::setType()
     * @param string $agent
     * @param \App\Insis\StructType\SiebelBeneficiary[] $beneficiary
     * @param string $bonusDesc
     * @param int $bonusPerc
     * @param string $comPercent
     * @param int $comPersentMax
     * @param int $comPersentMin
     * @param string $comRateType
     * @param string $comSum
     * @param string $conditions
     * @param string $creditDocDate
     * @param string $creditDocNum
     * @param string $currency
     * @param int $currencyRate
     * @param string $dateEndProtection
     * @param string $dateStartProtection
     * @param string $description
     * @param int $discountPercent
     * @param string $discountReason
     * @param string $eSBDId
     * @param string $franchise
     * @param string $franchiseConditions
     * @param int $franchisePerc
     * @param string $franchiseType
     * @param string $guarantlyDocNum
     * @param string $insPlace
     * @param string $insPrem
     * @param string $insSum
     * @param string $insTerritory
     * @param \App\Insis\StructType\SiebelInsurer[] $insurer
     * @param string $manager
     * @param string $numBasicPolicy
     * @param string $numGenPolicy
     * @param string $numPolicy
     * @param \App\Insis\StructType\SiebelObject[] $object
     * @param string $ownRetention
     * @param \App\Insis\StructType\SiebelPaymentFact[] $paymentFact
     * @param \App\Insis\StructType\SiebelPaymentPlan[] $paymentPlan
     * @param string $policyDate
     * @param string $product
     * @param string $promotion
     * @param string $rate
     * @param string $realizationChannel
     * @param string $realizationDetails
     * @param \App\Insis\StructType\SiebelPaymentOffset[] $siebelPaymentOffset
     * @param string $status
     * @param string $type
     */
    public function __construct($agent = null, array $beneficiary = array(), $bonusDesc = null, $bonusPerc = null, $comPercent = null, $comPersentMax = null, $comPersentMin = null, $comRateType = null, $comSum = null, $conditions = null, $creditDocDate = null, $creditDocNum = null, $currency = null, $currencyRate = null, $dateEndProtection = null, $dateStartProtection = null, $description = null, $discountPercent = null, $discountReason = null, $eSBDId = null, $franchise = null, $franchiseConditions = null, $franchisePerc = null, $franchiseType = null, $guarantlyDocNum = null, $insPlace = null, $insPrem = null, $insSum = null, $insTerritory = null, array $insurer = array(), $manager = null, $numBasicPolicy = null, $numGenPolicy = null, $numPolicy = null, array $object = array(), $ownRetention = null, array $paymentFact = array(), array $paymentPlan = array(), $policyDate = null, $product = null, $promotion = null, $rate = null, $realizationChannel = null, $realizationDetails = null, array $siebelPaymentOffset = array(), $status = null, $type = null)
    {
        $this
            ->setAgent($agent)
            ->setBeneficiary($beneficiary)
            ->setBonusDesc($bonusDesc)
            ->setBonusPerc($bonusPerc)
            ->setComPercent($comPercent)
            ->setComPersentMax($comPersentMax)
            ->setComPersentMin($comPersentMin)
            ->setComRateType($comRateType)
            ->setComSum($comSum)
            ->setConditions($conditions)
            ->setCreditDocDate($creditDocDate)
            ->setCreditDocNum($creditDocNum)
            ->setCurrency($currency)
            ->setCurrencyRate($currencyRate)
            ->setDateEndProtection($dateEndProtection)
            ->setDateStartProtection($dateStartProtection)
            ->setDescription($description)
            ->setDiscountPercent($discountPercent)
            ->setDiscountReason($discountReason)
            ->setESBDId($eSBDId)
            ->setFranchise($franchise)
            ->setFranchiseConditions($franchiseConditions)
            ->setFranchisePerc($franchisePerc)
            ->setFranchiseType($franchiseType)
            ->setGuarantlyDocNum($guarantlyDocNum)
            ->setInsPlace($insPlace)
            ->setInsPrem($insPrem)
            ->setInsSum($insSum)
            ->setInsTerritory($insTerritory)
            ->setInsurer($insurer)
            ->setManager($manager)
            ->setNumBasicPolicy($numBasicPolicy)
            ->setNumGenPolicy($numGenPolicy)
            ->setNumPolicy($numPolicy)
            ->setObject($object)
            ->setOwnRetention($ownRetention)
            ->setPaymentFact($paymentFact)
            ->setPaymentPlan($paymentPlan)
            ->setPolicyDate($policyDate)
            ->setProduct($product)
            ->setPromotion($promotion)
            ->setRate($rate)
            ->setRealizationChannel($realizationChannel)
            ->setRealizationDetails($realizationDetails)
            ->setSiebelPaymentOffset($siebelPaymentOffset)
            ->setStatus($status)
            ->setType($type);
    }
    /**
     * Get agent value
     * @return string|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param string $agent
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setAgent($agent = null)
    {
        // validation for constraint: string
        if (!is_null($agent) && !is_string($agent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agent, true), gettype($agent)), __LINE__);
        }
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get beneficiary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelBeneficiary[]|null
     */
    public function getBeneficiary()
    {
        return isset($this->beneficiary) ? $this->beneficiary : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBeneficiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeneficiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeneficiaryForArrayConstraintsFromSetBeneficiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelPolicyBeneficiaryItem) {
            // validation for constraint: itemType
            if (!$siebelPolicyBeneficiaryItem instanceof \App\Insis\StructType\SiebelBeneficiary) {
                $invalidValues[] = is_object($siebelPolicyBeneficiaryItem) ? get_class($siebelPolicyBeneficiaryItem) : sprintf('%s(%s)', gettype($siebelPolicyBeneficiaryItem), var_export($siebelPolicyBeneficiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beneficiary property can only contain items of type \App\Insis\StructType\SiebelBeneficiary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beneficiary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelBeneficiary[] $beneficiary
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setBeneficiary(array $beneficiary = array())
    {
        // validation for constraint: array
        if ('' !== ($beneficiaryArrayErrorMessage = self::validateBeneficiaryForArrayConstraintsFromSetBeneficiary($beneficiary))) {
            throw new \InvalidArgumentException($beneficiaryArrayErrorMessage, __LINE__);
        }
        if (is_null($beneficiary) || (is_array($beneficiary) && empty($beneficiary))) {
            unset($this->beneficiary);
        } else {
            $this->beneficiary = $beneficiary;
        }
        return $this;
    }
    /**
     * Add item to beneficiary value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelBeneficiary $item
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function addToBeneficiary(\App\Insis\StructType\SiebelBeneficiary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelBeneficiary) {
            throw new \InvalidArgumentException(sprintf('The beneficiary property can only contain items of type \App\Insis\StructType\SiebelBeneficiary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beneficiary[] = $item;
        return $this;
    }
    /**
     * Get bonusDesc value
     * @return string|null
     */
    public function getBonusDesc()
    {
        return $this->bonusDesc;
    }
    /**
     * Set bonusDesc value
     * @param string $bonusDesc
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setBonusDesc($bonusDesc = null)
    {
        // validation for constraint: string
        if (!is_null($bonusDesc) && !is_string($bonusDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bonusDesc, true), gettype($bonusDesc)), __LINE__);
        }
        $this->bonusDesc = $bonusDesc;
        return $this;
    }
    /**
     * Get bonusPerc value
     * @return int|null
     */
    public function getBonusPerc()
    {
        return $this->bonusPerc;
    }
    /**
     * Set bonusPerc value
     * @param int $bonusPerc
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setBonusPerc($bonusPerc = null)
    {
        // validation for constraint: int
        if (!is_null($bonusPerc) && !(is_int($bonusPerc) || ctype_digit($bonusPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusPerc, true), gettype($bonusPerc)), __LINE__);
        }
        $this->bonusPerc = $bonusPerc;
        return $this;
    }
    /**
     * Get comPercent value
     * @return string|null
     */
    public function getComPercent()
    {
        return $this->comPercent;
    }
    /**
     * Set comPercent value
     * @param string $comPercent
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setComPercent($comPercent = null)
    {
        // validation for constraint: string
        if (!is_null($comPercent) && !is_string($comPercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comPercent, true), gettype($comPercent)), __LINE__);
        }
        $this->comPercent = $comPercent;
        return $this;
    }
    /**
     * Get comPersentMax value
     * @return int|null
     */
    public function getComPersentMax()
    {
        return $this->comPersentMax;
    }
    /**
     * Set comPersentMax value
     * @param int $comPersentMax
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setComPersentMax($comPersentMax = null)
    {
        // validation for constraint: int
        if (!is_null($comPersentMax) && !(is_int($comPersentMax) || ctype_digit($comPersentMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($comPersentMax, true), gettype($comPersentMax)), __LINE__);
        }
        $this->comPersentMax = $comPersentMax;
        return $this;
    }
    /**
     * Get comPersentMin value
     * @return int|null
     */
    public function getComPersentMin()
    {
        return $this->comPersentMin;
    }
    /**
     * Set comPersentMin value
     * @param int $comPersentMin
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setComPersentMin($comPersentMin = null)
    {
        // validation for constraint: int
        if (!is_null($comPersentMin) && !(is_int($comPersentMin) || ctype_digit($comPersentMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($comPersentMin, true), gettype($comPersentMin)), __LINE__);
        }
        $this->comPersentMin = $comPersentMin;
        return $this;
    }
    /**
     * Get comRateType value
     * @return string|null
     */
    public function getComRateType()
    {
        return $this->comRateType;
    }
    /**
     * Set comRateType value
     * @param string $comRateType
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setComRateType($comRateType = null)
    {
        // validation for constraint: string
        if (!is_null($comRateType) && !is_string($comRateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comRateType, true), gettype($comRateType)), __LINE__);
        }
        $this->comRateType = $comRateType;
        return $this;
    }
    /**
     * Get comSum value
     * @return string|null
     */
    public function getComSum()
    {
        return $this->comSum;
    }
    /**
     * Set comSum value
     * @param string $comSum
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setComSum($comSum = null)
    {
        // validation for constraint: string
        if (!is_null($comSum) && !is_string($comSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comSum, true), gettype($comSum)), __LINE__);
        }
        $this->comSum = $comSum;
        return $this;
    }
    /**
     * Get conditions value
     * @return string|null
     */
    public function getConditions()
    {
        return $this->conditions;
    }
    /**
     * Set conditions value
     * @param string $conditions
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setConditions($conditions = null)
    {
        // validation for constraint: string
        if (!is_null($conditions) && !is_string($conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditions, true), gettype($conditions)), __LINE__);
        }
        $this->conditions = $conditions;
        return $this;
    }
    /**
     * Get creditDocDate value
     * @return string|null
     */
    public function getCreditDocDate()
    {
        return $this->creditDocDate;
    }
    /**
     * Set creditDocDate value
     * @param string $creditDocDate
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setCreditDocDate($creditDocDate = null)
    {
        // validation for constraint: string
        if (!is_null($creditDocDate) && !is_string($creditDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditDocDate, true), gettype($creditDocDate)), __LINE__);
        }
        $this->creditDocDate = $creditDocDate;
        return $this;
    }
    /**
     * Get creditDocNum value
     * @return string|null
     */
    public function getCreditDocNum()
    {
        return $this->creditDocNum;
    }
    /**
     * Set creditDocNum value
     * @param string $creditDocNum
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setCreditDocNum($creditDocNum = null)
    {
        // validation for constraint: string
        if (!is_null($creditDocNum) && !is_string($creditDocNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditDocNum, true), gettype($creditDocNum)), __LINE__);
        }
        $this->creditDocNum = $creditDocNum;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get currencyRate value
     * @return int|null
     */
    public function getCurrencyRate()
    {
        return $this->currencyRate;
    }
    /**
     * Set currencyRate value
     * @param int $currencyRate
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setCurrencyRate($currencyRate = null)
    {
        // validation for constraint: int
        if (!is_null($currencyRate) && !(is_int($currencyRate) || ctype_digit($currencyRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyRate, true), gettype($currencyRate)), __LINE__);
        }
        $this->currencyRate = $currencyRate;
        return $this;
    }
    /**
     * Get dateEndProtection value
     * @return string|null
     */
    public function getDateEndProtection()
    {
        return $this->dateEndProtection;
    }
    /**
     * Set dateEndProtection value
     * @param string $dateEndProtection
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setDateEndProtection($dateEndProtection = null)
    {
        // validation for constraint: string
        if (!is_null($dateEndProtection) && !is_string($dateEndProtection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEndProtection, true), gettype($dateEndProtection)), __LINE__);
        }
        $this->dateEndProtection = $dateEndProtection;
        return $this;
    }
    /**
     * Get dateStartProtection value
     * @return string|null
     */
    public function getDateStartProtection()
    {
        return $this->dateStartProtection;
    }
    /**
     * Set dateStartProtection value
     * @param string $dateStartProtection
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setDateStartProtection($dateStartProtection = null)
    {
        // validation for constraint: string
        if (!is_null($dateStartProtection) && !is_string($dateStartProtection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateStartProtection, true), gettype($dateStartProtection)), __LINE__);
        }
        $this->dateStartProtection = $dateStartProtection;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get discountPercent value
     * @return int|null
     */
    public function getDiscountPercent()
    {
        return $this->discountPercent;
    }
    /**
     * Set discountPercent value
     * @param int $discountPercent
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: int
        if (!is_null($discountPercent) && !(is_int($discountPercent) || ctype_digit($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->discountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get discountReason value
     * @return string|null
     */
    public function getDiscountReason()
    {
        return $this->discountReason;
    }
    /**
     * Set discountReason value
     * @param string $discountReason
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setDiscountReason($discountReason = null)
    {
        // validation for constraint: string
        if (!is_null($discountReason) && !is_string($discountReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountReason, true), gettype($discountReason)), __LINE__);
        }
        $this->discountReason = $discountReason;
        return $this;
    }
    /**
     * Get ESBDId value
     * @return string|null
     */
    public function getESBDId()
    {
        return $this->ESBDId;
    }
    /**
     * Set ESBDId value
     * @param string $eSBDId
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setESBDId($eSBDId = null)
    {
        // validation for constraint: string
        if (!is_null($eSBDId) && !is_string($eSBDId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eSBDId, true), gettype($eSBDId)), __LINE__);
        }
        $this->ESBDId = $eSBDId;
        return $this;
    }
    /**
     * Get franchise value
     * @return string|null
     */
    public function getFranchise()
    {
        return $this->franchise;
    }
    /**
     * Set franchise value
     * @param string $franchise
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setFranchise($franchise = null)
    {
        // validation for constraint: string
        if (!is_null($franchise) && !is_string($franchise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franchise, true), gettype($franchise)), __LINE__);
        }
        $this->franchise = $franchise;
        return $this;
    }
    /**
     * Get franchiseConditions value
     * @return string|null
     */
    public function getFranchiseConditions()
    {
        return $this->franchiseConditions;
    }
    /**
     * Set franchiseConditions value
     * @param string $franchiseConditions
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setFranchiseConditions($franchiseConditions = null)
    {
        // validation for constraint: string
        if (!is_null($franchiseConditions) && !is_string($franchiseConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franchiseConditions, true), gettype($franchiseConditions)), __LINE__);
        }
        $this->franchiseConditions = $franchiseConditions;
        return $this;
    }
    /**
     * Get franchisePerc value
     * @return int|null
     */
    public function getFranchisePerc()
    {
        return $this->franchisePerc;
    }
    /**
     * Set franchisePerc value
     * @param int $franchisePerc
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setFranchisePerc($franchisePerc = null)
    {
        // validation for constraint: int
        if (!is_null($franchisePerc) && !(is_int($franchisePerc) || ctype_digit($franchisePerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($franchisePerc, true), gettype($franchisePerc)), __LINE__);
        }
        $this->franchisePerc = $franchisePerc;
        return $this;
    }
    /**
     * Get franchiseType value
     * @return string|null
     */
    public function getFranchiseType()
    {
        return $this->franchiseType;
    }
    /**
     * Set franchiseType value
     * @param string $franchiseType
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setFranchiseType($franchiseType = null)
    {
        // validation for constraint: string
        if (!is_null($franchiseType) && !is_string($franchiseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franchiseType, true), gettype($franchiseType)), __LINE__);
        }
        $this->franchiseType = $franchiseType;
        return $this;
    }
    /**
     * Get guarantlyDocNum value
     * @return string|null
     */
    public function getGuarantlyDocNum()
    {
        return $this->guarantlyDocNum;
    }
    /**
     * Set guarantlyDocNum value
     * @param string $guarantlyDocNum
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setGuarantlyDocNum($guarantlyDocNum = null)
    {
        // validation for constraint: string
        if (!is_null($guarantlyDocNum) && !is_string($guarantlyDocNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guarantlyDocNum, true), gettype($guarantlyDocNum)), __LINE__);
        }
        $this->guarantlyDocNum = $guarantlyDocNum;
        return $this;
    }
    /**
     * Get insPlace value
     * @return string|null
     */
    public function getInsPlace()
    {
        return $this->insPlace;
    }
    /**
     * Set insPlace value
     * @param string $insPlace
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setInsPlace($insPlace = null)
    {
        // validation for constraint: string
        if (!is_null($insPlace) && !is_string($insPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insPlace, true), gettype($insPlace)), __LINE__);
        }
        $this->insPlace = $insPlace;
        return $this;
    }
    /**
     * Get insPrem value
     * @return string|null
     */
    public function getInsPrem()
    {
        return $this->insPrem;
    }
    /**
     * Set insPrem value
     * @param string $insPrem
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setInsPrem($insPrem = null)
    {
        // validation for constraint: string
        if (!is_null($insPrem) && !is_string($insPrem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insPrem, true), gettype($insPrem)), __LINE__);
        }
        $this->insPrem = $insPrem;
        return $this;
    }
    /**
     * Get insSum value
     * @return string|null
     */
    public function getInsSum()
    {
        return $this->insSum;
    }
    /**
     * Set insSum value
     * @param string $insSum
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setInsSum($insSum = null)
    {
        // validation for constraint: string
        if (!is_null($insSum) && !is_string($insSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insSum, true), gettype($insSum)), __LINE__);
        }
        $this->insSum = $insSum;
        return $this;
    }
    /**
     * Get insTerritory value
     * @return string|null
     */
    public function getInsTerritory()
    {
        return $this->insTerritory;
    }
    /**
     * Set insTerritory value
     * @param string $insTerritory
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setInsTerritory($insTerritory = null)
    {
        // validation for constraint: string
        if (!is_null($insTerritory) && !is_string($insTerritory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insTerritory, true), gettype($insTerritory)), __LINE__);
        }
        $this->insTerritory = $insTerritory;
        return $this;
    }
    /**
     * Get insurer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelInsurer[]|null
     */
    public function getInsurer()
    {
        return isset($this->insurer) ? $this->insurer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsurerForArrayConstraintsFromSetInsurer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelPolicyInsurerItem) {
            // validation for constraint: itemType
            if (!$siebelPolicyInsurerItem instanceof \App\Insis\StructType\SiebelInsurer) {
                $invalidValues[] = is_object($siebelPolicyInsurerItem) ? get_class($siebelPolicyInsurerItem) : sprintf('%s(%s)', gettype($siebelPolicyInsurerItem), var_export($siebelPolicyInsurerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insurer property can only contain items of type \App\Insis\StructType\SiebelInsurer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insurer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelInsurer[] $insurer
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setInsurer(array $insurer = array())
    {
        // validation for constraint: array
        if ('' !== ($insurerArrayErrorMessage = self::validateInsurerForArrayConstraintsFromSetInsurer($insurer))) {
            throw new \InvalidArgumentException($insurerArrayErrorMessage, __LINE__);
        }
        if (is_null($insurer) || (is_array($insurer) && empty($insurer))) {
            unset($this->insurer);
        } else {
            $this->insurer = $insurer;
        }
        return $this;
    }
    /**
     * Add item to insurer value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelInsurer $item
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function addToInsurer(\App\Insis\StructType\SiebelInsurer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelInsurer) {
            throw new \InvalidArgumentException(sprintf('The insurer property can only contain items of type \App\Insis\StructType\SiebelInsurer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insurer[] = $item;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manager, true), gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get numBasicPolicy value
     * @return string|null
     */
    public function getNumBasicPolicy()
    {
        return $this->numBasicPolicy;
    }
    /**
     * Set numBasicPolicy value
     * @param string $numBasicPolicy
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setNumBasicPolicy($numBasicPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($numBasicPolicy) && !is_string($numBasicPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numBasicPolicy, true), gettype($numBasicPolicy)), __LINE__);
        }
        $this->numBasicPolicy = $numBasicPolicy;
        return $this;
    }
    /**
     * Get numGenPolicy value
     * @return string|null
     */
    public function getNumGenPolicy()
    {
        return $this->numGenPolicy;
    }
    /**
     * Set numGenPolicy value
     * @param string $numGenPolicy
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setNumGenPolicy($numGenPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($numGenPolicy) && !is_string($numGenPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numGenPolicy, true), gettype($numGenPolicy)), __LINE__);
        }
        $this->numGenPolicy = $numGenPolicy;
        return $this;
    }
    /**
     * Get numPolicy value
     * @return string|null
     */
    public function getNumPolicy()
    {
        return $this->numPolicy;
    }
    /**
     * Set numPolicy value
     * @param string $numPolicy
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setNumPolicy($numPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($numPolicy) && !is_string($numPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPolicy, true), gettype($numPolicy)), __LINE__);
        }
        $this->numPolicy = $numPolicy;
        return $this;
    }
    /**
     * Get object value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelObject[]|null
     */
    public function getObject()
    {
        return isset($this->object) ? $this->object : null;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelPolicyObjectItem) {
            // validation for constraint: itemType
            if (!$siebelPolicyObjectItem instanceof \App\Insis\StructType\SiebelObject) {
                $invalidValues[] = is_object($siebelPolicyObjectItem) ? get_class($siebelPolicyObjectItem) : sprintf('%s(%s)', gettype($siebelPolicyObjectItem), var_export($siebelPolicyObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The object property can only contain items of type \App\Insis\StructType\SiebelObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set object value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelObject[] $object
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        if (is_null($object) || (is_array($object) && empty($object))) {
            unset($this->object);
        } else {
            $this->object = $object;
        }
        return $this;
    }
    /**
     * Add item to object value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelObject $item
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function addToObject(\App\Insis\StructType\SiebelObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelObject) {
            throw new \InvalidArgumentException(sprintf('The object property can only contain items of type \App\Insis\StructType\SiebelObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->object[] = $item;
        return $this;
    }
    /**
     * Get ownRetention value
     * @return string|null
     */
    public function getOwnRetention()
    {
        return $this->ownRetention;
    }
    /**
     * Set ownRetention value
     * @param string $ownRetention
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setOwnRetention($ownRetention = null)
    {
        // validation for constraint: string
        if (!is_null($ownRetention) && !is_string($ownRetention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownRetention, true), gettype($ownRetention)), __LINE__);
        }
        $this->ownRetention = $ownRetention;
        return $this;
    }
    /**
     * Get paymentFact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelPaymentFact[]|null
     */
    public function getPaymentFact()
    {
        return isset($this->paymentFact) ? $this->paymentFact : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFactForArrayConstraintsFromSetPaymentFact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelPolicyPaymentFactItem) {
            // validation for constraint: itemType
            if (!$siebelPolicyPaymentFactItem instanceof \App\Insis\StructType\SiebelPaymentFact) {
                $invalidValues[] = is_object($siebelPolicyPaymentFactItem) ? get_class($siebelPolicyPaymentFactItem) : sprintf('%s(%s)', gettype($siebelPolicyPaymentFactItem), var_export($siebelPolicyPaymentFactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paymentFact property can only contain items of type \App\Insis\StructType\SiebelPaymentFact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paymentFact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelPaymentFact[] $paymentFact
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setPaymentFact(array $paymentFact = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFactArrayErrorMessage = self::validatePaymentFactForArrayConstraintsFromSetPaymentFact($paymentFact))) {
            throw new \InvalidArgumentException($paymentFactArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentFact) || (is_array($paymentFact) && empty($paymentFact))) {
            unset($this->paymentFact);
        } else {
            $this->paymentFact = $paymentFact;
        }
        return $this;
    }
    /**
     * Add item to paymentFact value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelPaymentFact $item
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function addToPaymentFact(\App\Insis\StructType\SiebelPaymentFact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelPaymentFact) {
            throw new \InvalidArgumentException(sprintf('The paymentFact property can only contain items of type \App\Insis\StructType\SiebelPaymentFact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paymentFact[] = $item;
        return $this;
    }
    /**
     * Get paymentPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelPaymentPlan[]|null
     */
    public function getPaymentPlan()
    {
        return isset($this->paymentPlan) ? $this->paymentPlan : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentPlan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentPlan method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentPlanForArrayConstraintsFromSetPaymentPlan(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelPolicyPaymentPlanItem) {
            // validation for constraint: itemType
            if (!$siebelPolicyPaymentPlanItem instanceof \App\Insis\StructType\SiebelPaymentPlan) {
                $invalidValues[] = is_object($siebelPolicyPaymentPlanItem) ? get_class($siebelPolicyPaymentPlanItem) : sprintf('%s(%s)', gettype($siebelPolicyPaymentPlanItem), var_export($siebelPolicyPaymentPlanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paymentPlan property can only contain items of type \App\Insis\StructType\SiebelPaymentPlan, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paymentPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelPaymentPlan[] $paymentPlan
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setPaymentPlan(array $paymentPlan = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentPlanArrayErrorMessage = self::validatePaymentPlanForArrayConstraintsFromSetPaymentPlan($paymentPlan))) {
            throw new \InvalidArgumentException($paymentPlanArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentPlan) || (is_array($paymentPlan) && empty($paymentPlan))) {
            unset($this->paymentPlan);
        } else {
            $this->paymentPlan = $paymentPlan;
        }
        return $this;
    }
    /**
     * Add item to paymentPlan value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelPaymentPlan $item
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function addToPaymentPlan(\App\Insis\StructType\SiebelPaymentPlan $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelPaymentPlan) {
            throw new \InvalidArgumentException(sprintf('The paymentPlan property can only contain items of type \App\Insis\StructType\SiebelPaymentPlan, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paymentPlan[] = $item;
        return $this;
    }
    /**
     * Get policyDate value
     * @return string|null
     */
    public function getPolicyDate()
    {
        return $this->policyDate;
    }
    /**
     * Set policyDate value
     * @param string $policyDate
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setPolicyDate($policyDate = null)
    {
        // validation for constraint: string
        if (!is_null($policyDate) && !is_string($policyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyDate, true), gettype($policyDate)), __LINE__);
        }
        $this->policyDate = $policyDate;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get promotion value
     * @return string|null
     */
    public function getPromotion()
    {
        return $this->promotion;
    }
    /**
     * Set promotion value
     * @param string $promotion
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setPromotion($promotion = null)
    {
        // validation for constraint: string
        if (!is_null($promotion) && !is_string($promotion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotion, true), gettype($promotion)), __LINE__);
        }
        $this->promotion = $promotion;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get realizationChannel value
     * @return string|null
     */
    public function getRealizationChannel()
    {
        return $this->realizationChannel;
    }
    /**
     * Set realizationChannel value
     * @param string $realizationChannel
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setRealizationChannel($realizationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($realizationChannel) && !is_string($realizationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realizationChannel, true), gettype($realizationChannel)), __LINE__);
        }
        $this->realizationChannel = $realizationChannel;
        return $this;
    }
    /**
     * Get realizationDetails value
     * @return string|null
     */
    public function getRealizationDetails()
    {
        return $this->realizationDetails;
    }
    /**
     * Set realizationDetails value
     * @param string $realizationDetails
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setRealizationDetails($realizationDetails = null)
    {
        // validation for constraint: string
        if (!is_null($realizationDetails) && !is_string($realizationDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realizationDetails, true), gettype($realizationDetails)), __LINE__);
        }
        $this->realizationDetails = $realizationDetails;
        return $this;
    }
    /**
     * Get siebelPaymentOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelPaymentOffset[]|null
     */
    public function getSiebelPaymentOffset()
    {
        return isset($this->siebelPaymentOffset) ? $this->siebelPaymentOffset : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSiebelPaymentOffset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSiebelPaymentOffset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSiebelPaymentOffsetForArrayConstraintsFromSetSiebelPaymentOffset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelPolicySiebelPaymentOffsetItem) {
            // validation for constraint: itemType
            if (!$siebelPolicySiebelPaymentOffsetItem instanceof \App\Insis\StructType\SiebelPaymentOffset) {
                $invalidValues[] = is_object($siebelPolicySiebelPaymentOffsetItem) ? get_class($siebelPolicySiebelPaymentOffsetItem) : sprintf('%s(%s)', gettype($siebelPolicySiebelPaymentOffsetItem), var_export($siebelPolicySiebelPaymentOffsetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The siebelPaymentOffset property can only contain items of type \App\Insis\StructType\SiebelPaymentOffset, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set siebelPaymentOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelPaymentOffset[] $siebelPaymentOffset
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setSiebelPaymentOffset(array $siebelPaymentOffset = array())
    {
        // validation for constraint: array
        if ('' !== ($siebelPaymentOffsetArrayErrorMessage = self::validateSiebelPaymentOffsetForArrayConstraintsFromSetSiebelPaymentOffset($siebelPaymentOffset))) {
            throw new \InvalidArgumentException($siebelPaymentOffsetArrayErrorMessage, __LINE__);
        }
        if (is_null($siebelPaymentOffset) || (is_array($siebelPaymentOffset) && empty($siebelPaymentOffset))) {
            unset($this->siebelPaymentOffset);
        } else {
            $this->siebelPaymentOffset = $siebelPaymentOffset;
        }
        return $this;
    }
    /**
     * Add item to siebelPaymentOffset value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelPaymentOffset $item
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function addToSiebelPaymentOffset(\App\Insis\StructType\SiebelPaymentOffset $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelPaymentOffset) {
            throw new \InvalidArgumentException(sprintf('The siebelPaymentOffset property can only contain items of type \App\Insis\StructType\SiebelPaymentOffset, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->siebelPaymentOffset[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Insis\StructType\SiebelPolicy
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
