<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelPaymentFact StructType
 * @subpackage Structs
 */
class SiebelPaymentFact extends AbstractStructBase
{
    /**
     * The numPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numPayment;
    /**
     * The numPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numPolicy;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The sum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sum;
    /**
     * Constructor method for siebelPaymentFact
     * @uses SiebelPaymentFact::setNumPayment()
     * @uses SiebelPaymentFact::setNumPolicy()
     * @uses SiebelPaymentFact::setNumber()
     * @uses SiebelPaymentFact::setSum()
     * @param string $numPayment
     * @param string $numPolicy
     * @param string $number
     * @param string $sum
     */
    public function __construct($numPayment = null, $numPolicy = null, $number = null, $sum = null)
    {
        $this
            ->setNumPayment($numPayment)
            ->setNumPolicy($numPolicy)
            ->setNumber($number)
            ->setSum($sum);
    }
    /**
     * Get numPayment value
     * @return string|null
     */
    public function getNumPayment()
    {
        return $this->numPayment;
    }
    /**
     * Set numPayment value
     * @param string $numPayment
     * @return \App\Insis\StructType\SiebelPaymentFact
     */
    public function setNumPayment($numPayment = null)
    {
        // validation for constraint: string
        if (!is_null($numPayment) && !is_string($numPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPayment, true), gettype($numPayment)), __LINE__);
        }
        $this->numPayment = $numPayment;
        return $this;
    }
    /**
     * Get numPolicy value
     * @return string|null
     */
    public function getNumPolicy()
    {
        return $this->numPolicy;
    }
    /**
     * Set numPolicy value
     * @param string $numPolicy
     * @return \App\Insis\StructType\SiebelPaymentFact
     */
    public function setNumPolicy($numPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($numPolicy) && !is_string($numPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPolicy, true), gettype($numPolicy)), __LINE__);
        }
        $this->numPolicy = $numPolicy;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \App\Insis\StructType\SiebelPaymentFact
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get sum value
     * @return string|null
     */
    public function getSum()
    {
        return $this->sum;
    }
    /**
     * Set sum value
     * @param string $sum
     * @return \App\Insis\StructType\SiebelPaymentFact
     */
    public function setSum($sum = null)
    {
        // validation for constraint: string
        if (!is_null($sum) && !is_string($sum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        $this->sum = $sum;
        return $this;
    }
}
