<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelInsurerBank StructType
 * @subpackage Structs
 */
class SiebelInsurerBank extends AbstractStructBase
{
    /**
     * The BIK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BIK;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * Constructor method for siebelInsurerBank
     * @uses SiebelInsurerBank::setBIK()
     * @uses SiebelInsurerBank::setCurrency()
     * @uses SiebelInsurerBank::setIBAN()
     * @param string $bIK
     * @param string $currency
     * @param string $iBAN
     */
    public function __construct($bIK = null, $currency = null, $iBAN = null)
    {
        $this
            ->setBIK($bIK)
            ->setCurrency($currency)
            ->setIBAN($iBAN);
    }
    /**
     * Get BIK value
     * @return string|null
     */
    public function getBIK()
    {
        return $this->BIK;
    }
    /**
     * Set BIK value
     * @param string $bIK
     * @return \App\Insis\StructType\SiebelInsurerBank
     */
    public function setBIK($bIK = null)
    {
        // validation for constraint: string
        if (!is_null($bIK) && !is_string($bIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIK, true), gettype($bIK)), __LINE__);
        }
        $this->BIK = $bIK;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \App\Insis\StructType\SiebelInsurerBank
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \App\Insis\StructType\SiebelInsurerBank
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
}
