<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelInsurer StructType
 * @subpackage Structs
 */
class SiebelInsurer extends AbstractStructBase
{
    /**
     * The accountFlg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountFlg;
    /**
     * The accountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountName;
    /**
     * The BIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BIN;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The IIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IIN;
    /**
     * The insurerAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelInsurerAddress[]
     */
    public $insurerAddress;
    /**
     * The insurerBank
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelInsurerBank[]
     */
    public $insurerBank;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The residence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residence;
    /**
     * The sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sector;
    /**
     * Constructor method for siebelInsurer
     * @uses SiebelInsurer::setAccountFlg()
     * @uses SiebelInsurer::setAccountName()
     * @uses SiebelInsurer::setBIN()
     * @uses SiebelInsurer::setBirthDate()
     * @uses SiebelInsurer::setCountry()
     * @uses SiebelInsurer::setIIN()
     * @uses SiebelInsurer::setInsurerAddress()
     * @uses SiebelInsurer::setInsurerBank()
     * @uses SiebelInsurer::setLastName()
     * @uses SiebelInsurer::setName()
     * @uses SiebelInsurer::setResidence()
     * @uses SiebelInsurer::setSector()
     * @param string $accountFlg
     * @param string $accountName
     * @param string $bIN
     * @param string $birthDate
     * @param string $country
     * @param string $iIN
     * @param \App\Insis\StructType\SiebelInsurerAddress[] $insurerAddress
     * @param \App\Insis\StructType\SiebelInsurerBank[] $insurerBank
     * @param string $lastName
     * @param string $name
     * @param string $residence
     * @param string $sector
     */
    public function __construct($accountFlg = null, $accountName = null, $bIN = null, $birthDate = null, $country = null, $iIN = null, array $insurerAddress = array(), array $insurerBank = array(), $lastName = null, $name = null, $residence = null, $sector = null)
    {
        $this
            ->setAccountFlg($accountFlg)
            ->setAccountName($accountName)
            ->setBIN($bIN)
            ->setBirthDate($birthDate)
            ->setCountry($country)
            ->setIIN($iIN)
            ->setInsurerAddress($insurerAddress)
            ->setInsurerBank($insurerBank)
            ->setLastName($lastName)
            ->setName($name)
            ->setResidence($residence)
            ->setSector($sector);
    }
    /**
     * Get accountFlg value
     * @return string|null
     */
    public function getAccountFlg()
    {
        return $this->accountFlg;
    }
    /**
     * Set accountFlg value
     * @param string $accountFlg
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setAccountFlg($accountFlg = null)
    {
        // validation for constraint: string
        if (!is_null($accountFlg) && !is_string($accountFlg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountFlg, true), gettype($accountFlg)), __LINE__);
        }
        $this->accountFlg = $accountFlg;
        return $this;
    }
    /**
     * Get accountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->accountName;
    }
    /**
     * Set accountName value
     * @param string $accountName
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->accountName = $accountName;
        return $this;
    }
    /**
     * Get BIN value
     * @return string|null
     */
    public function getBIN()
    {
        return $this->BIN;
    }
    /**
     * Set BIN value
     * @param string $bIN
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setBIN($bIN = null)
    {
        // validation for constraint: string
        if (!is_null($bIN) && !is_string($bIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIN, true), gettype($bIN)), __LINE__);
        }
        $this->BIN = $bIN;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get IIN value
     * @return string|null
     */
    public function getIIN()
    {
        return $this->IIN;
    }
    /**
     * Set IIN value
     * @param string $iIN
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setIIN($iIN = null)
    {
        // validation for constraint: string
        if (!is_null($iIN) && !is_string($iIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iIN, true), gettype($iIN)), __LINE__);
        }
        $this->IIN = $iIN;
        return $this;
    }
    /**
     * Get insurerAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelInsurerAddress[]|null
     */
    public function getInsurerAddress()
    {
        return isset($this->insurerAddress) ? $this->insurerAddress : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurerAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurerAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsurerAddressForArrayConstraintsFromSetInsurerAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelInsurerInsurerAddressItem) {
            // validation for constraint: itemType
            if (!$siebelInsurerInsurerAddressItem instanceof \App\Insis\StructType\SiebelInsurerAddress) {
                $invalidValues[] = is_object($siebelInsurerInsurerAddressItem) ? get_class($siebelInsurerInsurerAddressItem) : sprintf('%s(%s)', gettype($siebelInsurerInsurerAddressItem), var_export($siebelInsurerInsurerAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insurerAddress property can only contain items of type \App\Insis\StructType\SiebelInsurerAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insurerAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelInsurerAddress[] $insurerAddress
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setInsurerAddress(array $insurerAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($insurerAddressArrayErrorMessage = self::validateInsurerAddressForArrayConstraintsFromSetInsurerAddress($insurerAddress))) {
            throw new \InvalidArgumentException($insurerAddressArrayErrorMessage, __LINE__);
        }
        if (is_null($insurerAddress) || (is_array($insurerAddress) && empty($insurerAddress))) {
            unset($this->insurerAddress);
        } else {
            $this->insurerAddress = $insurerAddress;
        }
        return $this;
    }
    /**
     * Add item to insurerAddress value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelInsurerAddress $item
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function addToInsurerAddress(\App\Insis\StructType\SiebelInsurerAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelInsurerAddress) {
            throw new \InvalidArgumentException(sprintf('The insurerAddress property can only contain items of type \App\Insis\StructType\SiebelInsurerAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insurerAddress[] = $item;
        return $this;
    }
    /**
     * Get insurerBank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelInsurerBank[]|null
     */
    public function getInsurerBank()
    {
        return isset($this->insurerBank) ? $this->insurerBank : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurerBank method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurerBank method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsurerBankForArrayConstraintsFromSetInsurerBank(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelInsurerInsurerBankItem) {
            // validation for constraint: itemType
            if (!$siebelInsurerInsurerBankItem instanceof \App\Insis\StructType\SiebelInsurerBank) {
                $invalidValues[] = is_object($siebelInsurerInsurerBankItem) ? get_class($siebelInsurerInsurerBankItem) : sprintf('%s(%s)', gettype($siebelInsurerInsurerBankItem), var_export($siebelInsurerInsurerBankItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insurerBank property can only contain items of type \App\Insis\StructType\SiebelInsurerBank, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insurerBank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelInsurerBank[] $insurerBank
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setInsurerBank(array $insurerBank = array())
    {
        // validation for constraint: array
        if ('' !== ($insurerBankArrayErrorMessage = self::validateInsurerBankForArrayConstraintsFromSetInsurerBank($insurerBank))) {
            throw new \InvalidArgumentException($insurerBankArrayErrorMessage, __LINE__);
        }
        if (is_null($insurerBank) || (is_array($insurerBank) && empty($insurerBank))) {
            unset($this->insurerBank);
        } else {
            $this->insurerBank = $insurerBank;
        }
        return $this;
    }
    /**
     * Add item to insurerBank value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelInsurerBank $item
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function addToInsurerBank(\App\Insis\StructType\SiebelInsurerBank $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelInsurerBank) {
            throw new \InvalidArgumentException(sprintf('The insurerBank property can only contain items of type \App\Insis\StructType\SiebelInsurerBank, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insurerBank[] = $item;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get residence value
     * @return string|null
     */
    public function getResidence()
    {
        return $this->residence;
    }
    /**
     * Set residence value
     * @param string $residence
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setResidence($residence = null)
    {
        // validation for constraint: string
        if (!is_null($residence) && !is_string($residence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residence, true), gettype($residence)), __LINE__);
        }
        $this->residence = $residence;
        return $this;
    }
    /**
     * Get sector value
     * @return string|null
     */
    public function getSector()
    {
        return $this->sector;
    }
    /**
     * Set sector value
     * @param string $sector
     * @return \App\Insis\StructType\SiebelInsurer
     */
    public function setSector($sector = null)
    {
        // validation for constraint: string
        if (!is_null($sector) && !is_string($sector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sector, true), gettype($sector)), __LINE__);
        }
        $this->sector = $sector;
        return $this;
    }
}
