<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelBoxPayment StructType
 * @subpackage Structs
 */
class SiebelBoxPayment extends AbstractStructBase
{
    /**
     * The BOX_NUMBER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BOX_NUMBER;
    /**
     * The BOX_PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BOX_PRICE;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $error;
    /**
     * The FIRST_NAME
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FIRST_NAME;
    /**
     * The IIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IIN;
    /**
     * The LAST_NAME
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LAST_NAME;
    /**
     * The OTCHESTVO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OTCHESTVO;
    /**
     * Constructor method for siebelBoxPayment
     * @uses SiebelBoxPayment::setBOX_NUMBER()
     * @uses SiebelBoxPayment::setBOX_PRICE()
     * @uses SiebelBoxPayment::setError()
     * @uses SiebelBoxPayment::setFIRST_NAME()
     * @uses SiebelBoxPayment::setIIN()
     * @uses SiebelBoxPayment::setLAST_NAME()
     * @uses SiebelBoxPayment::setOTCHESTVO()
     * @param string $bOX_NUMBER
     * @param string $bOX_PRICE
     * @param string $error
     * @param string $fIRST_NAME
     * @param string $iIN
     * @param string $lAST_NAME
     * @param string $oTCHESTVO
     */
    public function __construct($bOX_NUMBER = null, $bOX_PRICE = null, $error = null, $fIRST_NAME = null, $iIN = null, $lAST_NAME = null, $oTCHESTVO = null)
    {
        $this
            ->setBOX_NUMBER($bOX_NUMBER)
            ->setBOX_PRICE($bOX_PRICE)
            ->setError($error)
            ->setFIRST_NAME($fIRST_NAME)
            ->setIIN($iIN)
            ->setLAST_NAME($lAST_NAME)
            ->setOTCHESTVO($oTCHESTVO);
    }
    /**
     * Get BOX_NUMBER value
     * @return string|null
     */
    public function getBOX_NUMBER()
    {
        return $this->BOX_NUMBER;
    }
    /**
     * Set BOX_NUMBER value
     * @param string $bOX_NUMBER
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setBOX_NUMBER($bOX_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($bOX_NUMBER) && !is_string($bOX_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bOX_NUMBER, true), gettype($bOX_NUMBER)), __LINE__);
        }
        $this->BOX_NUMBER = $bOX_NUMBER;
        return $this;
    }
    /**
     * Get BOX_PRICE value
     * @return string|null
     */
    public function getBOX_PRICE()
    {
        return $this->BOX_PRICE;
    }
    /**
     * Set BOX_PRICE value
     * @param string $bOX_PRICE
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setBOX_PRICE($bOX_PRICE = null)
    {
        // validation for constraint: string
        if (!is_null($bOX_PRICE) && !is_string($bOX_PRICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bOX_PRICE, true), gettype($bOX_PRICE)), __LINE__);
        }
        $this->BOX_PRICE = $bOX_PRICE;
        return $this;
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Get FIRST_NAME value
     * @return string|null
     */
    public function getFIRST_NAME()
    {
        return $this->FIRST_NAME;
    }
    /**
     * Set FIRST_NAME value
     * @param string $fIRST_NAME
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setFIRST_NAME($fIRST_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($fIRST_NAME) && !is_string($fIRST_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fIRST_NAME, true), gettype($fIRST_NAME)), __LINE__);
        }
        $this->FIRST_NAME = $fIRST_NAME;
        return $this;
    }
    /**
     * Get IIN value
     * @return string|null
     */
    public function getIIN()
    {
        return $this->IIN;
    }
    /**
     * Set IIN value
     * @param string $iIN
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setIIN($iIN = null)
    {
        // validation for constraint: string
        if (!is_null($iIN) && !is_string($iIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iIN, true), gettype($iIN)), __LINE__);
        }
        $this->IIN = $iIN;
        return $this;
    }
    /**
     * Get LAST_NAME value
     * @return string|null
     */
    public function getLAST_NAME()
    {
        return $this->LAST_NAME;
    }
    /**
     * Set LAST_NAME value
     * @param string $lAST_NAME
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setLAST_NAME($lAST_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($lAST_NAME) && !is_string($lAST_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lAST_NAME, true), gettype($lAST_NAME)), __LINE__);
        }
        $this->LAST_NAME = $lAST_NAME;
        return $this;
    }
    /**
     * Get OTCHESTVO value
     * @return string|null
     */
    public function getOTCHESTVO()
    {
        return $this->OTCHESTVO;
    }
    /**
     * Set OTCHESTVO value
     * @param string $oTCHESTVO
     * @return \App\Insis\StructType\SiebelBoxPayment
     */
    public function setOTCHESTVO($oTCHESTVO = null)
    {
        // validation for constraint: string
        if (!is_null($oTCHESTVO) && !is_string($oTCHESTVO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oTCHESTVO, true), gettype($oTCHESTVO)), __LINE__);
        }
        $this->OTCHESTVO = $oTCHESTVO;
        return $this;
    }
}
