<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setPaymentSite StructType
 * Meta information extracted from the WSDL
 * - type: tns:setPaymentSite
 * @subpackage Structs
 */
class SetPaymentSite extends AbstractStructBase
{
    /**
     * The PolicyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PolicyID;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentRef;
    /**
     * The Premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Premium;
    /**
     * The InputDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InputDate;
    /**
     * Constructor method for setPaymentSite
     * @uses SetPaymentSite::setPolicyID()
     * @uses SetPaymentSite::setPaymentRef()
     * @uses SetPaymentSite::setPremium()
     * @uses SetPaymentSite::setInputDate()
     * @param int $policyID
     * @param string $paymentRef
     * @param float $premium
     * @param string $inputDate
     */
    public function __construct($policyID = null, $paymentRef = null, $premium = null, $inputDate = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setPaymentRef($paymentRef)
            ->setPremium($premium)
            ->setInputDate($inputDate);
    }
    /**
     * Get PolicyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->PolicyID;
    }
    /**
     * Set PolicyID value
     * @param int $policyID
     * @return \App\Insis\StructType\SetPaymentSite
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->PolicyID = $policyID;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \App\Insis\StructType\SetPaymentSite
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get Premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param float $premium
     * @return \App\Insis\StructType\SetPaymentSite
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get InputDate value
     * @return string|null
     */
    public function getInputDate()
    {
        return $this->InputDate;
    }
    /**
     * Set InputDate value
     * @param string $inputDate
     * @return \App\Insis\StructType\SetPaymentSite
     */
    public function setInputDate($inputDate = null)
    {
        // validation for constraint: string
        if (!is_null($inputDate) && !is_string($inputDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputDate, true), gettype($inputDate)), __LINE__);
        }
        $this->InputDate = $inputDate;
        return $this;
    }
}
