<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setPaymentReference StructType
 * Meta information extracted from the WSDL
 * - type: tns:setPaymentReference
 * @subpackage Structs
 */
class SetPaymentReference extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * The aPaymentRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPaymentRef;
    /**
     * Constructor method for setPaymentReference
     * @uses SetPaymentReference::setPolicyID()
     * @uses SetPaymentReference::setAPaymentRef()
     * @param int $policyID
     * @param string $aPaymentRef
     */
    public function __construct($policyID = null, $aPaymentRef = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setAPaymentRef($aPaymentRef);
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\SetPaymentReference
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get aPaymentRef value
     * @return string|null
     */
    public function getAPaymentRef()
    {
        return $this->aPaymentRef;
    }
    /**
     * Set aPaymentRef value
     * @param string $aPaymentRef
     * @return \App\Insis\StructType\SetPaymentReference
     */
    public function setAPaymentRef($aPaymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($aPaymentRef) && !is_string($aPaymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPaymentRef, true), gettype($aPaymentRef)), __LINE__);
        }
        $this->aPaymentRef = $aPaymentRef;
        return $this;
    }
}
