<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setBoxPayments StructType
 * Meta information extracted from the WSDL
 * - type: tns:setBoxPayments
 * @subpackage Structs
 */
class SetBoxPayments extends AbstractStructBase
{
    /**
     * The aBoxId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aBoxId;
    /**
     * The aPaymentChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPaymentChannel;
    /**
     * The aPremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $aPremium;
    /**
     * Constructor method for setBoxPayments
     * @uses SetBoxPayments::setABoxId()
     * @uses SetBoxPayments::setAPaymentChannel()
     * @uses SetBoxPayments::setAPremium()
     * @param int $aBoxId
     * @param string $aPaymentChannel
     * @param float $aPremium
     */
    public function __construct($aBoxId = null, $aPaymentChannel = null, $aPremium = null)
    {
        $this
            ->setABoxId($aBoxId)
            ->setAPaymentChannel($aPaymentChannel)
            ->setAPremium($aPremium);
    }
    /**
     * Get aBoxId value
     * @return int|null
     */
    public function getABoxId()
    {
        return $this->aBoxId;
    }
    /**
     * Set aBoxId value
     * @param int $aBoxId
     * @return \App\Insis\StructType\SetBoxPayments
     */
    public function setABoxId($aBoxId = null)
    {
        // validation for constraint: int
        if (!is_null($aBoxId) && !(is_int($aBoxId) || ctype_digit($aBoxId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aBoxId, true), gettype($aBoxId)), __LINE__);
        }
        $this->aBoxId = $aBoxId;
        return $this;
    }
    /**
     * Get aPaymentChannel value
     * @return string|null
     */
    public function getAPaymentChannel()
    {
        return $this->aPaymentChannel;
    }
    /**
     * Set aPaymentChannel value
     * @param string $aPaymentChannel
     * @return \App\Insis\StructType\SetBoxPayments
     */
    public function setAPaymentChannel($aPaymentChannel = null)
    {
        // validation for constraint: string
        if (!is_null($aPaymentChannel) && !is_string($aPaymentChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPaymentChannel, true), gettype($aPaymentChannel)), __LINE__);
        }
        $this->aPaymentChannel = $aPaymentChannel;
        return $this;
    }
    /**
     * Get aPremium value
     * @return float|null
     */
    public function getAPremium()
    {
        return $this->aPremium;
    }
    /**
     * Set aPremium value
     * @param float $aPremium
     * @return \App\Insis\StructType\SetBoxPayments
     */
    public function setAPremium($aPremium = null)
    {
        // validation for constraint: float
        if (!is_null($aPremium) && !(is_float($aPremium) || is_numeric($aPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aPremium, true), gettype($aPremium)), __LINE__);
        }
        $this->aPremium = $aPremium;
        return $this;
    }
}
