<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setBoxPayment StructType
 * Meta information extracted from the WSDL
 * - type: tns:setBoxPayment
 * @subpackage Structs
 */
class SetBoxPayment extends AbstractStructBase
{
    /**
     * The boxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $boxNumber;
    /**
     * The payAmnt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $payAmnt;
    /**
     * Constructor method for setBoxPayment
     * @uses SetBoxPayment::setBoxNumber()
     * @uses SetBoxPayment::setPayAmnt()
     * @param string $boxNumber
     * @param float $payAmnt
     */
    public function __construct($boxNumber = null, $payAmnt = null)
    {
        $this
            ->setBoxNumber($boxNumber)
            ->setPayAmnt($payAmnt);
    }
    /**
     * Get boxNumber value
     * @return string|null
     */
    public function getBoxNumber()
    {
        return $this->boxNumber;
    }
    /**
     * Set boxNumber value
     * @param string $boxNumber
     * @return \App\Insis\StructType\SetBoxPayment
     */
    public function setBoxNumber($boxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($boxNumber) && !is_string($boxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxNumber, true), gettype($boxNumber)), __LINE__);
        }
        $this->boxNumber = $boxNumber;
        return $this;
    }
    /**
     * Get payAmnt value
     * @return float|null
     */
    public function getPayAmnt()
    {
        return $this->payAmnt;
    }
    /**
     * Set payAmnt value
     * @param float $payAmnt
     * @return \App\Insis\StructType\SetBoxPayment
     */
    public function setPayAmnt($payAmnt = null)
    {
        // validation for constraint: float
        if (!is_null($payAmnt) && !(is_float($payAmnt) || is_numeric($payAmnt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payAmnt, true), gettype($payAmnt)), __LINE__);
        }
        $this->payAmnt = $payAmnt;
        return $this;
    }
}
