<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestData StructType
 * @subpackage Structs
 */
class RequestData extends AbstractStructBase
{
    /**
     * The agreementData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\AgreementData[]
     */
    public $agreementData;
    /**
     * The bank
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\HcsbkBank[]
     */
    public $bank;
    /**
     * The client
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\HcsbkClient[]
     */
    public $client;
    /**
     * The insuranceData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\InsuranceData[]
     */
    public $insuranceData;
    /**
     * The insurer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\HcsbkInsurer[]
     */
    public $insurer;
    /**
     * The pledger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\Pledger[]
     */
    public $pledger;
    /**
     * The realty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\Realty[]
     */
    public $realty;
    /**
     * Constructor method for requestData
     * @uses RequestData::setAgreementData()
     * @uses RequestData::setBank()
     * @uses RequestData::setClient()
     * @uses RequestData::setInsuranceData()
     * @uses RequestData::setInsurer()
     * @uses RequestData::setPledger()
     * @uses RequestData::setRealty()
     * @param \App\Insis\StructType\AgreementData[] $agreementData
     * @param \App\Insis\StructType\HcsbkBank[] $bank
     * @param \App\Insis\StructType\HcsbkClient[] $client
     * @param \App\Insis\StructType\InsuranceData[] $insuranceData
     * @param \App\Insis\StructType\HcsbkInsurer[] $insurer
     * @param \App\Insis\StructType\Pledger[] $pledger
     * @param \App\Insis\StructType\Realty[] $realty
     */
    public function __construct(array $agreementData = array(), array $bank = array(), array $client = array(), array $insuranceData = array(), array $insurer = array(), array $pledger = array(), array $realty = array())
    {
        $this
            ->setAgreementData($agreementData)
            ->setBank($bank)
            ->setClient($client)
            ->setInsuranceData($insuranceData)
            ->setInsurer($insurer)
            ->setPledger($pledger)
            ->setRealty($realty);
    }
    /**
     * Get agreementData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\AgreementData[]|null
     */
    public function getAgreementData()
    {
        return isset($this->agreementData) ? $this->agreementData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAgreementData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgreementData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgreementDataForArrayConstraintsFromSetAgreementData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataAgreementDataItem) {
            // validation for constraint: itemType
            if (!$requestDataAgreementDataItem instanceof \App\Insis\StructType\AgreementData) {
                $invalidValues[] = is_object($requestDataAgreementDataItem) ? get_class($requestDataAgreementDataItem) : sprintf('%s(%s)', gettype($requestDataAgreementDataItem), var_export($requestDataAgreementDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The agreementData property can only contain items of type \App\Insis\StructType\AgreementData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set agreementData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\AgreementData[] $agreementData
     * @return \App\Insis\StructType\RequestData
     */
    public function setAgreementData(array $agreementData = array())
    {
        // validation for constraint: array
        if ('' !== ($agreementDataArrayErrorMessage = self::validateAgreementDataForArrayConstraintsFromSetAgreementData($agreementData))) {
            throw new \InvalidArgumentException($agreementDataArrayErrorMessage, __LINE__);
        }
        if (is_null($agreementData) || (is_array($agreementData) && empty($agreementData))) {
            unset($this->agreementData);
        } else {
            $this->agreementData = $agreementData;
        }
        return $this;
    }
    /**
     * Add item to agreementData value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\AgreementData $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToAgreementData(\App\Insis\StructType\AgreementData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\AgreementData) {
            throw new \InvalidArgumentException(sprintf('The agreementData property can only contain items of type \App\Insis\StructType\AgreementData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->agreementData[] = $item;
        return $this;
    }
    /**
     * Get bank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\HcsbkBank[]|null
     */
    public function getBank()
    {
        return isset($this->bank) ? $this->bank : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBank method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBank method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankForArrayConstraintsFromSetBank(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataBankItem) {
            // validation for constraint: itemType
            if (!$requestDataBankItem instanceof \App\Insis\StructType\HcsbkBank) {
                $invalidValues[] = is_object($requestDataBankItem) ? get_class($requestDataBankItem) : sprintf('%s(%s)', gettype($requestDataBankItem), var_export($requestDataBankItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bank property can only contain items of type \App\Insis\StructType\HcsbkBank, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkBank[] $bank
     * @return \App\Insis\StructType\RequestData
     */
    public function setBank(array $bank = array())
    {
        // validation for constraint: array
        if ('' !== ($bankArrayErrorMessage = self::validateBankForArrayConstraintsFromSetBank($bank))) {
            throw new \InvalidArgumentException($bankArrayErrorMessage, __LINE__);
        }
        if (is_null($bank) || (is_array($bank) && empty($bank))) {
            unset($this->bank);
        } else {
            $this->bank = $bank;
        }
        return $this;
    }
    /**
     * Add item to bank value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkBank $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToBank(\App\Insis\StructType\HcsbkBank $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\HcsbkBank) {
            throw new \InvalidArgumentException(sprintf('The bank property can only contain items of type \App\Insis\StructType\HcsbkBank, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bank[] = $item;
        return $this;
    }
    /**
     * Get client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\HcsbkClient[]|null
     */
    public function getClient()
    {
        return isset($this->client) ? $this->client : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClient method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClient method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientForArrayConstraintsFromSetClient(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataClientItem) {
            // validation for constraint: itemType
            if (!$requestDataClientItem instanceof \App\Insis\StructType\HcsbkClient) {
                $invalidValues[] = is_object($requestDataClientItem) ? get_class($requestDataClientItem) : sprintf('%s(%s)', gettype($requestDataClientItem), var_export($requestDataClientItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The client property can only contain items of type \App\Insis\StructType\HcsbkClient, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkClient[] $client
     * @return \App\Insis\StructType\RequestData
     */
    public function setClient(array $client = array())
    {
        // validation for constraint: array
        if ('' !== ($clientArrayErrorMessage = self::validateClientForArrayConstraintsFromSetClient($client))) {
            throw new \InvalidArgumentException($clientArrayErrorMessage, __LINE__);
        }
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->client);
        } else {
            $this->client = $client;
        }
        return $this;
    }
    /**
     * Add item to client value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkClient $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToClient(\App\Insis\StructType\HcsbkClient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\HcsbkClient) {
            throw new \InvalidArgumentException(sprintf('The client property can only contain items of type \App\Insis\StructType\HcsbkClient, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->client[] = $item;
        return $this;
    }
    /**
     * Get insuranceData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\InsuranceData[]|null
     */
    public function getInsuranceData()
    {
        return isset($this->insuranceData) ? $this->insuranceData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsuranceData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsuranceData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuranceDataForArrayConstraintsFromSetInsuranceData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataInsuranceDataItem) {
            // validation for constraint: itemType
            if (!$requestDataInsuranceDataItem instanceof \App\Insis\StructType\InsuranceData) {
                $invalidValues[] = is_object($requestDataInsuranceDataItem) ? get_class($requestDataInsuranceDataItem) : sprintf('%s(%s)', gettype($requestDataInsuranceDataItem), var_export($requestDataInsuranceDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insuranceData property can only contain items of type \App\Insis\StructType\InsuranceData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insuranceData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\InsuranceData[] $insuranceData
     * @return \App\Insis\StructType\RequestData
     */
    public function setInsuranceData(array $insuranceData = array())
    {
        // validation for constraint: array
        if ('' !== ($insuranceDataArrayErrorMessage = self::validateInsuranceDataForArrayConstraintsFromSetInsuranceData($insuranceData))) {
            throw new \InvalidArgumentException($insuranceDataArrayErrorMessage, __LINE__);
        }
        if (is_null($insuranceData) || (is_array($insuranceData) && empty($insuranceData))) {
            unset($this->insuranceData);
        } else {
            $this->insuranceData = $insuranceData;
        }
        return $this;
    }
    /**
     * Add item to insuranceData value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\InsuranceData $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToInsuranceData(\App\Insis\StructType\InsuranceData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\InsuranceData) {
            throw new \InvalidArgumentException(sprintf('The insuranceData property can only contain items of type \App\Insis\StructType\InsuranceData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insuranceData[] = $item;
        return $this;
    }
    /**
     * Get insurer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\HcsbkInsurer[]|null
     */
    public function getInsurer()
    {
        return isset($this->insurer) ? $this->insurer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsurerForArrayConstraintsFromSetInsurer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataInsurerItem) {
            // validation for constraint: itemType
            if (!$requestDataInsurerItem instanceof \App\Insis\StructType\HcsbkInsurer) {
                $invalidValues[] = is_object($requestDataInsurerItem) ? get_class($requestDataInsurerItem) : sprintf('%s(%s)', gettype($requestDataInsurerItem), var_export($requestDataInsurerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insurer property can only contain items of type \App\Insis\StructType\HcsbkInsurer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insurer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkInsurer[] $insurer
     * @return \App\Insis\StructType\RequestData
     */
    public function setInsurer(array $insurer = array())
    {
        // validation for constraint: array
        if ('' !== ($insurerArrayErrorMessage = self::validateInsurerForArrayConstraintsFromSetInsurer($insurer))) {
            throw new \InvalidArgumentException($insurerArrayErrorMessage, __LINE__);
        }
        if (is_null($insurer) || (is_array($insurer) && empty($insurer))) {
            unset($this->insurer);
        } else {
            $this->insurer = $insurer;
        }
        return $this;
    }
    /**
     * Add item to insurer value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkInsurer $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToInsurer(\App\Insis\StructType\HcsbkInsurer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\HcsbkInsurer) {
            throw new \InvalidArgumentException(sprintf('The insurer property can only contain items of type \App\Insis\StructType\HcsbkInsurer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insurer[] = $item;
        return $this;
    }
    /**
     * Get pledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\Pledger[]|null
     */
    public function getPledger()
    {
        return isset($this->pledger) ? $this->pledger : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPledger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPledger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePledgerForArrayConstraintsFromSetPledger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataPledgerItem) {
            // validation for constraint: itemType
            if (!$requestDataPledgerItem instanceof \App\Insis\StructType\Pledger) {
                $invalidValues[] = is_object($requestDataPledgerItem) ? get_class($requestDataPledgerItem) : sprintf('%s(%s)', gettype($requestDataPledgerItem), var_export($requestDataPledgerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pledger property can only contain items of type \App\Insis\StructType\Pledger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Pledger[] $pledger
     * @return \App\Insis\StructType\RequestData
     */
    public function setPledger(array $pledger = array())
    {
        // validation for constraint: array
        if ('' !== ($pledgerArrayErrorMessage = self::validatePledgerForArrayConstraintsFromSetPledger($pledger))) {
            throw new \InvalidArgumentException($pledgerArrayErrorMessage, __LINE__);
        }
        if (is_null($pledger) || (is_array($pledger) && empty($pledger))) {
            unset($this->pledger);
        } else {
            $this->pledger = $pledger;
        }
        return $this;
    }
    /**
     * Add item to pledger value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Pledger $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToPledger(\App\Insis\StructType\Pledger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Pledger) {
            throw new \InvalidArgumentException(sprintf('The pledger property can only contain items of type \App\Insis\StructType\Pledger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pledger[] = $item;
        return $this;
    }
    /**
     * Get realty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\Realty[]|null
     */
    public function getRealty()
    {
        return isset($this->realty) ? $this->realty : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRealty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRealty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRealtyForArrayConstraintsFromSetRealty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestDataRealtyItem) {
            // validation for constraint: itemType
            if (!$requestDataRealtyItem instanceof \App\Insis\StructType\Realty) {
                $invalidValues[] = is_object($requestDataRealtyItem) ? get_class($requestDataRealtyItem) : sprintf('%s(%s)', gettype($requestDataRealtyItem), var_export($requestDataRealtyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The realty property can only contain items of type \App\Insis\StructType\Realty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set realty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Realty[] $realty
     * @return \App\Insis\StructType\RequestData
     */
    public function setRealty(array $realty = array())
    {
        // validation for constraint: array
        if ('' !== ($realtyArrayErrorMessage = self::validateRealtyForArrayConstraintsFromSetRealty($realty))) {
            throw new \InvalidArgumentException($realtyArrayErrorMessage, __LINE__);
        }
        if (is_null($realty) || (is_array($realty) && empty($realty))) {
            unset($this->realty);
        } else {
            $this->realty = $realty;
        }
        return $this;
    }
    /**
     * Add item to realty value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Realty $item
     * @return \App\Insis\StructType\RequestData
     */
    public function addToRealty(\App\Insis\StructType\Realty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Realty) {
            throw new \InvalidArgumentException(sprintf('The realty property can only contain items of type \App\Insis\StructType\Realty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->realty[] = $item;
        return $this;
    }
}
