<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reinsurer StructType
 * @subpackage Structs
 */
class Reinsurer extends AbstractStructBase
{
    /**
     * The reinsurerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reinsurerID;
    /**
     * The sharePercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sharePercent;
    /**
     * Constructor method for reinsurer
     * @uses Reinsurer::setReinsurerID()
     * @uses Reinsurer::setSharePercent()
     * @param int $reinsurerID
     * @param float $sharePercent
     */
    public function __construct($reinsurerID = null, $sharePercent = null)
    {
        $this
            ->setReinsurerID($reinsurerID)
            ->setSharePercent($sharePercent);
    }
    /**
     * Get reinsurerID value
     * @return int|null
     */
    public function getReinsurerID()
    {
        return $this->reinsurerID;
    }
    /**
     * Set reinsurerID value
     * @param int $reinsurerID
     * @return \App\Insis\StructType\Reinsurer
     */
    public function setReinsurerID($reinsurerID = null)
    {
        // validation for constraint: int
        if (!is_null($reinsurerID) && !(is_int($reinsurerID) || ctype_digit($reinsurerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reinsurerID, true), gettype($reinsurerID)), __LINE__);
        }
        $this->reinsurerID = $reinsurerID;
        return $this;
    }
    /**
     * Get sharePercent value
     * @return float|null
     */
    public function getSharePercent()
    {
        return $this->sharePercent;
    }
    /**
     * Set sharePercent value
     * @param float $sharePercent
     * @return \App\Insis\StructType\Reinsurer
     */
    public function setSharePercent($sharePercent = null)
    {
        // validation for constraint: float
        if (!is_null($sharePercent) && !(is_float($sharePercent) || is_numeric($sharePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sharePercent, true), gettype($sharePercent)), __LINE__);
        }
        $this->sharePercent = $sharePercent;
        return $this;
    }
}
