<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for realty StructType
 * @subpackage Structs
 */
class Realty extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The buildYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $buildYear;
    /**
     * The insurSector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insurSector;
    /**
     * The totalArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalArea;
    /**
     * The view
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The wallMaterialn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wallMaterialn;
    /**
     * Constructor method for realty
     * @uses Realty::setAddress()
     * @uses Realty::setBuildYear()
     * @uses Realty::setInsurSector()
     * @uses Realty::setTotalArea()
     * @uses Realty::setView()
     * @uses Realty::setWallMaterialn()
     * @param string $address
     * @param float $buildYear
     * @param string $insurSector
     * @param float $totalArea
     * @param string $view
     * @param string $wallMaterialn
     */
    public function __construct($address = null, $buildYear = null, $insurSector = null, $totalArea = null, $view = null, $wallMaterialn = null)
    {
        $this
            ->setAddress($address)
            ->setBuildYear($buildYear)
            ->setInsurSector($insurSector)
            ->setTotalArea($totalArea)
            ->setView($view)
            ->setWallMaterialn($wallMaterialn);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \App\Insis\StructType\Realty
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get buildYear value
     * @return float|null
     */
    public function getBuildYear()
    {
        return $this->buildYear;
    }
    /**
     * Set buildYear value
     * @param float $buildYear
     * @return \App\Insis\StructType\Realty
     */
    public function setBuildYear($buildYear = null)
    {
        // validation for constraint: float
        if (!is_null($buildYear) && !(is_float($buildYear) || is_numeric($buildYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buildYear, true), gettype($buildYear)), __LINE__);
        }
        $this->buildYear = $buildYear;
        return $this;
    }
    /**
     * Get insurSector value
     * @return string|null
     */
    public function getInsurSector()
    {
        return $this->insurSector;
    }
    /**
     * Set insurSector value
     * @param string $insurSector
     * @return \App\Insis\StructType\Realty
     */
    public function setInsurSector($insurSector = null)
    {
        // validation for constraint: string
        if (!is_null($insurSector) && !is_string($insurSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insurSector, true), gettype($insurSector)), __LINE__);
        }
        $this->insurSector = $insurSector;
        return $this;
    }
    /**
     * Get totalArea value
     * @return float|null
     */
    public function getTotalArea()
    {
        return $this->totalArea;
    }
    /**
     * Set totalArea value
     * @param float $totalArea
     * @return \App\Insis\StructType\Realty
     */
    public function setTotalArea($totalArea = null)
    {
        // validation for constraint: float
        if (!is_null($totalArea) && !(is_float($totalArea) || is_numeric($totalArea))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalArea, true), gettype($totalArea)), __LINE__);
        }
        $this->totalArea = $totalArea;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \App\Insis\StructType\Realty
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($view, true), gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get wallMaterialn value
     * @return string|null
     */
    public function getWallMaterialn()
    {
        return $this->wallMaterialn;
    }
    /**
     * Set wallMaterialn value
     * @param string $wallMaterialn
     * @return \App\Insis\StructType\Realty
     */
    public function setWallMaterialn($wallMaterialn = null)
    {
        // validation for constraint: string
        if (!is_null($wallMaterialn) && !is_string($wallMaterialn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wallMaterialn, true), gettype($wallMaterialn)), __LINE__);
        }
        $this->wallMaterialn = $wallMaterialn;
        return $this;
    }
}
