<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for policyPayment StructType
 * @subpackage Structs
 */
class PolicyPayment extends AbstractStructBase
{
    /**
     * The agentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $agentID;
    /**
     * The annexID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $annexID;
    /**
     * The annexes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $annexes;
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The blankNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankNumber;
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientID;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The insrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insrType;
    /**
     * The isProtected
     * @var bool
     */
    public $isProtected;
    /**
     * The issueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The operationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationType;
    /**
     * The payments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\Payment[]
     */
    public $payments;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * The premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $premium;
    /**
     * The sumForPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sumForPayment;
    /**
     * Constructor method for policyPayment
     * @uses PolicyPayment::setAgentID()
     * @uses PolicyPayment::setAnnexID()
     * @uses PolicyPayment::setAnnexes()
     * @uses PolicyPayment::setBeginDate()
     * @uses PolicyPayment::setBlankNumber()
     * @uses PolicyPayment::setClientID()
     * @uses PolicyPayment::setEndDate()
     * @uses PolicyPayment::setInsrType()
     * @uses PolicyPayment::setIsProtected()
     * @uses PolicyPayment::setIssueDate()
     * @uses PolicyPayment::setOperationType()
     * @uses PolicyPayment::setPayments()
     * @uses PolicyPayment::setPolicyID()
     * @uses PolicyPayment::setPremium()
     * @uses PolicyPayment::setSumForPayment()
     * @param int $agentID
     * @param int $annexID
     * @param \App\Insis\StructType\ObjectParam[] $annexes
     * @param string $beginDate
     * @param string $blankNumber
     * @param int $clientID
     * @param string $endDate
     * @param string $insrType
     * @param bool $isProtected
     * @param string $issueDate
     * @param string $operationType
     * @param \App\Insis\StructType\Payment[] $payments
     * @param int $policyID
     * @param float $premium
     * @param float $sumForPayment
     */
    public function __construct($agentID = null, $annexID = null, array $annexes = array(), $beginDate = null, $blankNumber = null, $clientID = null, $endDate = null, $insrType = null, $isProtected = null, $issueDate = null, $operationType = null, array $payments = array(), $policyID = null, $premium = null, $sumForPayment = null)
    {
        $this
            ->setAgentID($agentID)
            ->setAnnexID($annexID)
            ->setAnnexes($annexes)
            ->setBeginDate($beginDate)
            ->setBlankNumber($blankNumber)
            ->setClientID($clientID)
            ->setEndDate($endDate)
            ->setInsrType($insrType)
            ->setIsProtected($isProtected)
            ->setIssueDate($issueDate)
            ->setOperationType($operationType)
            ->setPayments($payments)
            ->setPolicyID($policyID)
            ->setPremium($premium)
            ->setSumForPayment($sumForPayment);
    }
    /**
     * Get agentID value
     * @return int|null
     */
    public function getAgentID()
    {
        return $this->agentID;
    }
    /**
     * Set agentID value
     * @param int $agentID
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: int
        if (!is_null($agentID) && !(is_int($agentID) || ctype_digit($agentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        $this->agentID = $agentID;
        return $this;
    }
    /**
     * Get annexID value
     * @return int|null
     */
    public function getAnnexID()
    {
        return $this->annexID;
    }
    /**
     * Set annexID value
     * @param int $annexID
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setAnnexID($annexID = null)
    {
        // validation for constraint: int
        if (!is_null($annexID) && !(is_int($annexID) || ctype_digit($annexID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annexID, true), gettype($annexID)), __LINE__);
        }
        $this->annexID = $annexID;
        return $this;
    }
    /**
     * Get annexes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getAnnexes()
    {
        return isset($this->annexes) ? $this->annexes : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnnexes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnnexes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnnexesForArrayConstraintsFromSetAnnexes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyPaymentAnnexesItem) {
            // validation for constraint: itemType
            if (!$policyPaymentAnnexesItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($policyPaymentAnnexesItem) ? get_class($policyPaymentAnnexesItem) : sprintf('%s(%s)', gettype($policyPaymentAnnexesItem), var_export($policyPaymentAnnexesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The annexes property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set annexes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $annexes
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setAnnexes(array $annexes = array())
    {
        // validation for constraint: array
        if ('' !== ($annexesArrayErrorMessage = self::validateAnnexesForArrayConstraintsFromSetAnnexes($annexes))) {
            throw new \InvalidArgumentException($annexesArrayErrorMessage, __LINE__);
        }
        if (is_null($annexes) || (is_array($annexes) && empty($annexes))) {
            unset($this->annexes);
        } else {
            $this->annexes = $annexes;
        }
        return $this;
    }
    /**
     * Add item to annexes value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function addToAnnexes(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The annexes property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->annexes[] = $item;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get blankNumber value
     * @return string|null
     */
    public function getBlankNumber()
    {
        return $this->blankNumber;
    }
    /**
     * Set blankNumber value
     * @param string $blankNumber
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setBlankNumber($blankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blankNumber) && !is_string($blankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankNumber, true), gettype($blankNumber)), __LINE__);
        }
        $this->blankNumber = $blankNumber;
        return $this;
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get insrType value
     * @return string|null
     */
    public function getInsrType()
    {
        return $this->insrType;
    }
    /**
     * Set insrType value
     * @param string $insrType
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: string
        if (!is_null($insrType) && !is_string($insrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->insrType = $insrType;
        return $this;
    }
    /**
     * Get isProtected value
     * @return bool|null
     */
    public function getIsProtected()
    {
        return $this->isProtected;
    }
    /**
     * Set isProtected value
     * @param bool $isProtected
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setIsProtected($isProtected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProtected) && !is_bool($isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProtected, true), gettype($isProtected)), __LINE__);
        }
        $this->isProtected = $isProtected;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get operationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->operationType;
    }
    /**
     * Set operationType value
     * @param string $operationType
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationType, true), gettype($operationType)), __LINE__);
        }
        $this->operationType = $operationType;
        return $this;
    }
    /**
     * Get payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\Payment[]|null
     */
    public function getPayments()
    {
        return isset($this->payments) ? $this->payments : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentsForArrayConstraintsFromSetPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyPaymentPaymentsItem) {
            // validation for constraint: itemType
            if (!$policyPaymentPaymentsItem instanceof \App\Insis\StructType\Payment) {
                $invalidValues[] = is_object($policyPaymentPaymentsItem) ? get_class($policyPaymentPaymentsItem) : sprintf('%s(%s)', gettype($policyPaymentPaymentsItem), var_export($policyPaymentPaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payments property can only contain items of type \App\Insis\StructType\Payment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Payment[] $payments
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setPayments(array $payments = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentsArrayErrorMessage = self::validatePaymentsForArrayConstraintsFromSetPayments($payments))) {
            throw new \InvalidArgumentException($paymentsArrayErrorMessage, __LINE__);
        }
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->payments);
        } else {
            $this->payments = $payments;
        }
        return $this;
    }
    /**
     * Add item to payments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Payment $item
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function addToPayments(\App\Insis\StructType\Payment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Payment) {
            throw new \InvalidArgumentException(sprintf('The payments property can only contain items of type \App\Insis\StructType\Payment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payments[] = $item;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param float $premium
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get sumForPayment value
     * @return float|null
     */
    public function getSumForPayment()
    {
        return $this->sumForPayment;
    }
    /**
     * Set sumForPayment value
     * @param float $sumForPayment
     * @return \App\Insis\StructType\PolicyPayment
     */
    public function setSumForPayment($sumForPayment = null)
    {
        // validation for constraint: float
        if (!is_null($sumForPayment) && !(is_float($sumForPayment) || is_numeric($sumForPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sumForPayment, true), gettype($sumForPayment)), __LINE__);
        }
        $this->sumForPayment = $sumForPayment;
        return $this;
    }
}
