<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyObject StructType
 * @subpackage Structs
 */
class PolicyObject extends AbstractStructBase
{
    /**
     * The objectType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $objectType;
    /**
     * The objectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $objectID;
    /**
     * The ObjectState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ObjectState;
    /**
     * The variableParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $variableParams;
    /**
     * The objectCovers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectCover[]
     */
    public $objectCovers;
    /**
     * Constructor method for PolicyObject
     * @uses PolicyObject::setObjectType()
     * @uses PolicyObject::setObjectID()
     * @uses PolicyObject::setObjectState()
     * @uses PolicyObject::setVariableParams()
     * @uses PolicyObject::setObjectCovers()
     * @param int $objectType
     * @param int $objectID
     * @param int $objectState
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @param \App\Insis\StructType\ObjectCover[] $objectCovers
     */
    public function __construct($objectType = null, $objectID = null, $objectState = null, array $variableParams = array(), array $objectCovers = array())
    {
        $this
            ->setObjectType($objectType)
            ->setObjectID($objectID)
            ->setObjectState($objectState)
            ->setVariableParams($variableParams)
            ->setObjectCovers($objectCovers);
    }
    /**
     * Get objectType value
     * @return int|null
     */
    public function getObjectType()
    {
        return $this->objectType;
    }
    /**
     * Set objectType value
     * @param int $objectType
     * @return \App\Insis\StructType\PolicyObject
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: int
        if (!is_null($objectType) && !(is_int($objectType) || ctype_digit($objectType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectType, true), gettype($objectType)), __LINE__);
        }
        $this->objectType = $objectType;
        return $this;
    }
    /**
     * Get objectID value
     * @return int|null
     */
    public function getObjectID()
    {
        return $this->objectID;
    }
    /**
     * Set objectID value
     * @param int $objectID
     * @return \App\Insis\StructType\PolicyObject
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->objectID = $objectID;
        return $this;
    }
    /**
     * Get ObjectState value
     * @return int|null
     */
    public function getObjectState()
    {
        return $this->ObjectState;
    }
    /**
     * Set ObjectState value
     * @param int $objectState
     * @return \App\Insis\StructType\PolicyObject
     */
    public function setObjectState($objectState = null)
    {
        // validation for constraint: int
        if (!is_null($objectState) && !(is_int($objectState) || ctype_digit($objectState))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectState, true), gettype($objectState)), __LINE__);
        }
        $this->ObjectState = $objectState;
        return $this;
    }
    /**
     * Get variableParams value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getVariableParams()
    {
        return $this->variableParams;
    }
    /**
     * This method is responsible for validating the values passed to the setVariableParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariableParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariableParamsForArrayConstraintsFromSetVariableParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyObjectVariableParamsItem) {
            // validation for constraint: itemType
            if (!$policyObjectVariableParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($policyObjectVariableParamsItem) ? get_class($policyObjectVariableParamsItem) : sprintf('%s(%s)', gettype($policyObjectVariableParamsItem), var_export($policyObjectVariableParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @return \App\Insis\StructType\PolicyObject
     */
    public function setVariableParams(array $variableParams = array())
    {
        // validation for constraint: array
        if ('' !== ($variableParamsArrayErrorMessage = self::validateVariableParamsForArrayConstraintsFromSetVariableParams($variableParams))) {
            throw new \InvalidArgumentException($variableParamsArrayErrorMessage, __LINE__);
        }
        $this->variableParams = $variableParams;
        return $this;
    }
    /**
     * Add item to variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\PolicyObject
     */
    public function addToVariableParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variableParams[] = $item;
        return $this;
    }
    /**
     * Get objectCovers value
     * @return \App\Insis\StructType\ObjectCover[]|null
     */
    public function getObjectCovers()
    {
        return $this->objectCovers;
    }
    /**
     * This method is responsible for validating the values passed to the setObjectCovers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjectCovers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectCoversForArrayConstraintsFromSetObjectCovers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyObjectObjectCoversItem) {
            // validation for constraint: itemType
            if (!$policyObjectObjectCoversItem instanceof \App\Insis\StructType\ObjectCover) {
                $invalidValues[] = is_object($policyObjectObjectCoversItem) ? get_class($policyObjectObjectCoversItem) : sprintf('%s(%s)', gettype($policyObjectObjectCoversItem), var_export($policyObjectObjectCoversItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The objectCovers property can only contain items of type \App\Insis\StructType\ObjectCover, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set objectCovers value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectCover[] $objectCovers
     * @return \App\Insis\StructType\PolicyObject
     */
    public function setObjectCovers(array $objectCovers = array())
    {
        // validation for constraint: array
        if ('' !== ($objectCoversArrayErrorMessage = self::validateObjectCoversForArrayConstraintsFromSetObjectCovers($objectCovers))) {
            throw new \InvalidArgumentException($objectCoversArrayErrorMessage, __LINE__);
        }
        $this->objectCovers = $objectCovers;
        return $this;
    }
    /**
     * Add item to objectCovers value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectCover $item
     * @return \App\Insis\StructType\PolicyObject
     */
    public function addToObjectCovers(\App\Insis\StructType\ObjectCover $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectCover) {
            throw new \InvalidArgumentException(sprintf('The objectCovers property can only contain items of type \App\Insis\StructType\ObjectCover, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->objectCovers[] = $item;
        return $this;
    }
}
