<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyList StructType
 * @subpackage Structs
 */
class PolicyList extends AbstractStructBase
{
    /**
     * The policyTotalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyTotalCount;
    /**
     * The policies
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Policy[]
     */
    public $policies;
    /**
     * Constructor method for PolicyList
     * @uses PolicyList::setPolicyTotalCount()
     * @uses PolicyList::setPolicies()
     * @param int $policyTotalCount
     * @param \App\Insis\StructType\Policy[] $policies
     */
    public function __construct($policyTotalCount = null, array $policies = array())
    {
        $this
            ->setPolicyTotalCount($policyTotalCount)
            ->setPolicies($policies);
    }
    /**
     * Get policyTotalCount value
     * @return int|null
     */
    public function getPolicyTotalCount()
    {
        return $this->policyTotalCount;
    }
    /**
     * Set policyTotalCount value
     * @param int $policyTotalCount
     * @return \App\Insis\StructType\PolicyList
     */
    public function setPolicyTotalCount($policyTotalCount = null)
    {
        // validation for constraint: int
        if (!is_null($policyTotalCount) && !(is_int($policyTotalCount) || ctype_digit($policyTotalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyTotalCount, true), gettype($policyTotalCount)), __LINE__);
        }
        $this->policyTotalCount = $policyTotalCount;
        return $this;
    }
    /**
     * Get policies value
     * @return \App\Insis\StructType\Policy[]|null
     */
    public function getPolicies()
    {
        return $this->policies;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicies method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicies method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoliciesForArrayConstraintsFromSetPolicies(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyListPoliciesItem) {
            // validation for constraint: itemType
            if (!$policyListPoliciesItem instanceof \App\Insis\StructType\Policy) {
                $invalidValues[] = is_object($policyListPoliciesItem) ? get_class($policyListPoliciesItem) : sprintf('%s(%s)', gettype($policyListPoliciesItem), var_export($policyListPoliciesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The policies property can only contain items of type \App\Insis\StructType\Policy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policies value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Policy[] $policies
     * @return \App\Insis\StructType\PolicyList
     */
    public function setPolicies(array $policies = array())
    {
        // validation for constraint: array
        if ('' !== ($policiesArrayErrorMessage = self::validatePoliciesForArrayConstraintsFromSetPolicies($policies))) {
            throw new \InvalidArgumentException($policiesArrayErrorMessage, __LINE__);
        }
        $this->policies = $policies;
        return $this;
    }
    /**
     * Add item to policies value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Policy $item
     * @return \App\Insis\StructType\PolicyList
     */
    public function addToPolicies(\App\Insis\StructType\Policy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Policy) {
            throw new \InvalidArgumentException(sprintf('The policies property can only contain items of type \App\Insis\StructType\Policy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->policies[] = $item;
        return $this;
    }
}
