<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * The annexID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $annexID;
    /**
     * The policyNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNO;
    /**
     * The policyRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyRef;
    /**
     * The policyAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Application
     */
    public $policyAction;
    /**
     * The insrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insrType;
    /**
     * The officeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $officeID;
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientID;
    /**
     * The agentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $agentID;
    /**
     * The annexType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $annexType;
    /**
     * The annexReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $annexReason;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentType;
    /**
     * The paymentWay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentWay;
    /**
     * The policyState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyState;
    /**
     * The policyDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyDuration;
    /**
     * The policyDimension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyDimension;
    /**
     * The policyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyType;
    /**
     * The tariffRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffRule;
    /**
     * The issueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The retroactive
     * @var bool
     */
    public $retroactive;
    /**
     * The tempEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tempEntry;
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The actBeginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actBeginDate;
    /**
     * The printAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $printAction;
    /**
     * The actions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Application[]
     */
    public $actions;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The actEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actEndDate;
    /**
     * The blanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\PolicyBlanks[]
     */
    public $blanks;
    /**
     * The insureds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\People[]
     */
    public $insureds;
    /**
     * The objects
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\PolicyObject[]
     */
    public $objects;
    /**
     * The payments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Payment[]
     */
    public $payments;
    /**
     * The changeUserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $changeUserID;
    /**
     * The changeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $changeDate;
    /**
     * The salesChanelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $salesChanelID;
    /**
     * The attachments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Attachment[]
     */
    public $attachments;
    /**
     * The souvenirs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $souvenirs;
    /**
     * The apps
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Application[]
     */
    public $apps;
    /**
     * The variableParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $variableParams;
    /**
     * The doNotUseCSDB
     * @var bool
     */
    public $doNotUseCSDB;
    /**
     * The doNotUse1C
     * @var bool
     */
    public $doNotUse1C;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The customRefound
     * @var bool
     */
    public $customRefound;
    /**
     * The doNotUseArchiveUsedPolicy
     * @var bool
     */
    public $doNotUseArchiveUsedPolicy;
    /**
     * The podft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $podft;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The verifications
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $verifications;
    /**
     * The VerificationBool
     * @var bool
     */
    public $VerificationBool;
    /**
     * The OnlineBool
     * @var bool
     */
    public $OnlineBool;
    /**
     * Constructor method for Policy
     * @uses Policy::setPolicyID()
     * @uses Policy::setAnnexID()
     * @uses Policy::setPolicyNO()
     * @uses Policy::setPolicyRef()
     * @uses Policy::setPolicyAction()
     * @uses Policy::setInsrType()
     * @uses Policy::setOfficeID()
     * @uses Policy::setClientID()
     * @uses Policy::setAgentID()
     * @uses Policy::setAnnexType()
     * @uses Policy::setAnnexReason()
     * @uses Policy::setPaymentType()
     * @uses Policy::setPaymentWay()
     * @uses Policy::setPolicyState()
     * @uses Policy::setPolicyDuration()
     * @uses Policy::setPolicyDimension()
     * @uses Policy::setPolicyType()
     * @uses Policy::setTariffRule()
     * @uses Policy::setIssueDate()
     * @uses Policy::setRetroactive()
     * @uses Policy::setTempEntry()
     * @uses Policy::setBeginDate()
     * @uses Policy::setActBeginDate()
     * @uses Policy::setPrintAction()
     * @uses Policy::setActions()
     * @uses Policy::setEndDate()
     * @uses Policy::setActEndDate()
     * @uses Policy::setBlanks()
     * @uses Policy::setInsureds()
     * @uses Policy::setObjects()
     * @uses Policy::setPayments()
     * @uses Policy::setChangeUserID()
     * @uses Policy::setChangeDate()
     * @uses Policy::setSalesChanelID()
     * @uses Policy::setAttachments()
     * @uses Policy::setSouvenirs()
     * @uses Policy::setApps()
     * @uses Policy::setVariableParams()
     * @uses Policy::setDoNotUseCSDB()
     * @uses Policy::setDoNotUse1C()
     * @uses Policy::setComments()
     * @uses Policy::setCustomRefound()
     * @uses Policy::setDoNotUseArchiveUsedPolicy()
     * @uses Policy::setPodft()
     * @uses Policy::setCode()
     * @uses Policy::setVerifications()
     * @uses Policy::setVerificationBool()
     * @uses Policy::setOnlineBool()
     * @param int $policyID
     * @param int $annexID
     * @param string $policyNO
     * @param int $policyRef
     * @param \App\Insis\StructType\Application $policyAction
     * @param string $insrType
     * @param int $officeID
     * @param int $clientID
     * @param int $agentID
     * @param int $annexType
     * @param string $annexReason
     * @param string $paymentType
     * @param string $paymentWay
     * @param int $policyState
     * @param int $policyDuration
     * @param string $policyDimension
     * @param int $policyType
     * @param string $tariffRule
     * @param string $issueDate
     * @param bool $retroactive
     * @param int $tempEntry
     * @param string $beginDate
     * @param string $actBeginDate
     * @param int $printAction
     * @param \App\Insis\StructType\Application[] $actions
     * @param string $endDate
     * @param string $actEndDate
     * @param \App\Insis\StructType\PolicyBlanks[] $blanks
     * @param \App\Insis\StructType\People[] $insureds
     * @param \App\Insis\StructType\PolicyObject[] $objects
     * @param \App\Insis\StructType\Payment[] $payments
     * @param int $changeUserID
     * @param string $changeDate
     * @param int $salesChanelID
     * @param \App\Insis\StructType\Attachment[] $attachments
     * @param \App\Insis\StructType\ObjectParam[] $souvenirs
     * @param \App\Insis\StructType\Application[] $apps
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @param bool $doNotUseCSDB
     * @param bool $doNotUse1C
     * @param string $comments
     * @param bool $customRefound
     * @param bool $doNotUseArchiveUsedPolicy
     * @param string $podft
     * @param string $code
     * @param int[] $verifications
     * @param bool $verificationBool
     * @param bool $onlineBool
     */
    public function __construct($policyID = null, $annexID = null, $policyNO = null, $policyRef = null, \App\Insis\StructType\Application $policyAction = null, $insrType = null, $officeID = null, $clientID = null, $agentID = null, $annexType = null, $annexReason = null, $paymentType = null, $paymentWay = null, $policyState = null, $policyDuration = null, $policyDimension = null, $policyType = null, $tariffRule = null, $issueDate = null, $retroactive = null, $tempEntry = null, $beginDate = null, $actBeginDate = null, $printAction = null, array $actions = array(), $endDate = null, $actEndDate = null, array $blanks = array(), array $insureds = array(), array $objects = array(), array $payments = array(), $changeUserID = null, $changeDate = null, $salesChanelID = null, array $attachments = array(), array $souvenirs = array(), array $apps = array(), array $variableParams = array(), $doNotUseCSDB = null, $doNotUse1C = null, $comments = null, $customRefound = null, $doNotUseArchiveUsedPolicy = null, $podft = null, $code = null, array $verifications = array(), $verificationBool = null, $onlineBool = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setAnnexID($annexID)
            ->setPolicyNO($policyNO)
            ->setPolicyRef($policyRef)
            ->setPolicyAction($policyAction)
            ->setInsrType($insrType)
            ->setOfficeID($officeID)
            ->setClientID($clientID)
            ->setAgentID($agentID)
            ->setAnnexType($annexType)
            ->setAnnexReason($annexReason)
            ->setPaymentType($paymentType)
            ->setPaymentWay($paymentWay)
            ->setPolicyState($policyState)
            ->setPolicyDuration($policyDuration)
            ->setPolicyDimension($policyDimension)
            ->setPolicyType($policyType)
            ->setTariffRule($tariffRule)
            ->setIssueDate($issueDate)
            ->setRetroactive($retroactive)
            ->setTempEntry($tempEntry)
            ->setBeginDate($beginDate)
            ->setActBeginDate($actBeginDate)
            ->setPrintAction($printAction)
            ->setActions($actions)
            ->setEndDate($endDate)
            ->setActEndDate($actEndDate)
            ->setBlanks($blanks)
            ->setInsureds($insureds)
            ->setObjects($objects)
            ->setPayments($payments)
            ->setChangeUserID($changeUserID)
            ->setChangeDate($changeDate)
            ->setSalesChanelID($salesChanelID)
            ->setAttachments($attachments)
            ->setSouvenirs($souvenirs)
            ->setApps($apps)
            ->setVariableParams($variableParams)
            ->setDoNotUseCSDB($doNotUseCSDB)
            ->setDoNotUse1C($doNotUse1C)
            ->setComments($comments)
            ->setCustomRefound($customRefound)
            ->setDoNotUseArchiveUsedPolicy($doNotUseArchiveUsedPolicy)
            ->setPodft($podft)
            ->setCode($code)
            ->setVerifications($verifications)
            ->setVerificationBool($verificationBool)
            ->setOnlineBool($onlineBool);
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get annexID value
     * @return int|null
     */
    public function getAnnexID()
    {
        return $this->annexID;
    }
    /**
     * Set annexID value
     * @param int $annexID
     * @return \App\Insis\StructType\Policy
     */
    public function setAnnexID($annexID = null)
    {
        // validation for constraint: int
        if (!is_null($annexID) && !(is_int($annexID) || ctype_digit($annexID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annexID, true), gettype($annexID)), __LINE__);
        }
        $this->annexID = $annexID;
        return $this;
    }
    /**
     * Get policyNO value
     * @return string|null
     */
    public function getPolicyNO()
    {
        return $this->policyNO;
    }
    /**
     * Set policyNO value
     * @param string $policyNO
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyNO($policyNO = null)
    {
        // validation for constraint: string
        if (!is_null($policyNO) && !is_string($policyNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNO, true), gettype($policyNO)), __LINE__);
        }
        $this->policyNO = $policyNO;
        return $this;
    }
    /**
     * Get policyRef value
     * @return int|null
     */
    public function getPolicyRef()
    {
        return $this->policyRef;
    }
    /**
     * Set policyRef value
     * @param int $policyRef
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyRef($policyRef = null)
    {
        // validation for constraint: int
        if (!is_null($policyRef) && !(is_int($policyRef) || ctype_digit($policyRef))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyRef, true), gettype($policyRef)), __LINE__);
        }
        $this->policyRef = $policyRef;
        return $this;
    }
    /**
     * Get policyAction value
     * @return \App\Insis\StructType\Application|null
     */
    public function getPolicyAction()
    {
        return $this->policyAction;
    }
    /**
     * Set policyAction value
     * @param \App\Insis\StructType\Application $policyAction
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyAction(\App\Insis\StructType\Application $policyAction = null)
    {
        $this->policyAction = $policyAction;
        return $this;
    }
    /**
     * Get insrType value
     * @return string|null
     */
    public function getInsrType()
    {
        return $this->insrType;
    }
    /**
     * Set insrType value
     * @param string $insrType
     * @return \App\Insis\StructType\Policy
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: string
        if (!is_null($insrType) && !is_string($insrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->insrType = $insrType;
        return $this;
    }
    /**
     * Get officeID value
     * @return int|null
     */
    public function getOfficeID()
    {
        return $this->officeID;
    }
    /**
     * Set officeID value
     * @param int $officeID
     * @return \App\Insis\StructType\Policy
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: int
        if (!is_null($officeID) && !(is_int($officeID) || ctype_digit($officeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($officeID, true), gettype($officeID)), __LINE__);
        }
        $this->officeID = $officeID;
        return $this;
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \App\Insis\StructType\Policy
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get agentID value
     * @return int|null
     */
    public function getAgentID()
    {
        return $this->agentID;
    }
    /**
     * Set agentID value
     * @param int $agentID
     * @return \App\Insis\StructType\Policy
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: int
        if (!is_null($agentID) && !(is_int($agentID) || ctype_digit($agentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        $this->agentID = $agentID;
        return $this;
    }
    /**
     * Get annexType value
     * @return int|null
     */
    public function getAnnexType()
    {
        return $this->annexType;
    }
    /**
     * Set annexType value
     * @param int $annexType
     * @return \App\Insis\StructType\Policy
     */
    public function setAnnexType($annexType = null)
    {
        // validation for constraint: int
        if (!is_null($annexType) && !(is_int($annexType) || ctype_digit($annexType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annexType, true), gettype($annexType)), __LINE__);
        }
        $this->annexType = $annexType;
        return $this;
    }
    /**
     * Get annexReason value
     * @return string|null
     */
    public function getAnnexReason()
    {
        return $this->annexReason;
    }
    /**
     * Set annexReason value
     * @param string $annexReason
     * @return \App\Insis\StructType\Policy
     */
    public function setAnnexReason($annexReason = null)
    {
        // validation for constraint: string
        if (!is_null($annexReason) && !is_string($annexReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annexReason, true), gettype($annexReason)), __LINE__);
        }
        $this->annexReason = $annexReason;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param string $paymentType
     * @return \App\Insis\StructType\Policy
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get paymentWay value
     * @return string|null
     */
    public function getPaymentWay()
    {
        return $this->paymentWay;
    }
    /**
     * Set paymentWay value
     * @param string $paymentWay
     * @return \App\Insis\StructType\Policy
     */
    public function setPaymentWay($paymentWay = null)
    {
        // validation for constraint: string
        if (!is_null($paymentWay) && !is_string($paymentWay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentWay, true), gettype($paymentWay)), __LINE__);
        }
        $this->paymentWay = $paymentWay;
        return $this;
    }
    /**
     * Get policyState value
     * @return int|null
     */
    public function getPolicyState()
    {
        return $this->policyState;
    }
    /**
     * Set policyState value
     * @param int $policyState
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyState($policyState = null)
    {
        // validation for constraint: int
        if (!is_null($policyState) && !(is_int($policyState) || ctype_digit($policyState))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyState, true), gettype($policyState)), __LINE__);
        }
        $this->policyState = $policyState;
        return $this;
    }
    /**
     * Get policyDuration value
     * @return int|null
     */
    public function getPolicyDuration()
    {
        return $this->policyDuration;
    }
    /**
     * Set policyDuration value
     * @param int $policyDuration
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyDuration($policyDuration = null)
    {
        // validation for constraint: int
        if (!is_null($policyDuration) && !(is_int($policyDuration) || ctype_digit($policyDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyDuration, true), gettype($policyDuration)), __LINE__);
        }
        $this->policyDuration = $policyDuration;
        return $this;
    }
    /**
     * Get policyDimension value
     * @return string|null
     */
    public function getPolicyDimension()
    {
        return $this->policyDimension;
    }
    /**
     * Set policyDimension value
     * @param string $policyDimension
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyDimension($policyDimension = null)
    {
        // validation for constraint: string
        if (!is_null($policyDimension) && !is_string($policyDimension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyDimension, true), gettype($policyDimension)), __LINE__);
        }
        $this->policyDimension = $policyDimension;
        return $this;
    }
    /**
     * Get policyType value
     * @return int|null
     */
    public function getPolicyType()
    {
        return $this->policyType;
    }
    /**
     * Set policyType value
     * @param int $policyType
     * @return \App\Insis\StructType\Policy
     */
    public function setPolicyType($policyType = null)
    {
        // validation for constraint: int
        if (!is_null($policyType) && !(is_int($policyType) || ctype_digit($policyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyType, true), gettype($policyType)), __LINE__);
        }
        $this->policyType = $policyType;
        return $this;
    }
    /**
     * Get tariffRule value
     * @return string|null
     */
    public function getTariffRule()
    {
        return $this->tariffRule;
    }
    /**
     * Set tariffRule value
     * @param string $tariffRule
     * @return \App\Insis\StructType\Policy
     */
    public function setTariffRule($tariffRule = null)
    {
        // validation for constraint: string
        if (!is_null($tariffRule) && !is_string($tariffRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffRule, true), gettype($tariffRule)), __LINE__);
        }
        $this->tariffRule = $tariffRule;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \App\Insis\StructType\Policy
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get retroactive value
     * @return bool|null
     */
    public function getRetroactive()
    {
        return $this->retroactive;
    }
    /**
     * Set retroactive value
     * @param bool $retroactive
     * @return \App\Insis\StructType\Policy
     */
    public function setRetroactive($retroactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($retroactive) && !is_bool($retroactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retroactive, true), gettype($retroactive)), __LINE__);
        }
        $this->retroactive = $retroactive;
        return $this;
    }
    /**
     * Get tempEntry value
     * @return int|null
     */
    public function getTempEntry()
    {
        return $this->tempEntry;
    }
    /**
     * Set tempEntry value
     * @param int $tempEntry
     * @return \App\Insis\StructType\Policy
     */
    public function setTempEntry($tempEntry = null)
    {
        // validation for constraint: int
        if (!is_null($tempEntry) && !(is_int($tempEntry) || ctype_digit($tempEntry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tempEntry, true), gettype($tempEntry)), __LINE__);
        }
        $this->tempEntry = $tempEntry;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\Policy
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get actBeginDate value
     * @return string|null
     */
    public function getActBeginDate()
    {
        return $this->actBeginDate;
    }
    /**
     * Set actBeginDate value
     * @param string $actBeginDate
     * @return \App\Insis\StructType\Policy
     */
    public function setActBeginDate($actBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($actBeginDate) && !is_string($actBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actBeginDate, true), gettype($actBeginDate)), __LINE__);
        }
        $this->actBeginDate = $actBeginDate;
        return $this;
    }
    /**
     * Get printAction value
     * @return int|null
     */
    public function getPrintAction()
    {
        return $this->printAction;
    }
    /**
     * Set printAction value
     * @param int $printAction
     * @return \App\Insis\StructType\Policy
     */
    public function setPrintAction($printAction = null)
    {
        // validation for constraint: int
        if (!is_null($printAction) && !(is_int($printAction) || ctype_digit($printAction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printAction, true), gettype($printAction)), __LINE__);
        }
        $this->printAction = $printAction;
        return $this;
    }
    /**
     * Get actions value
     * @return \App\Insis\StructType\Application[]|null
     */
    public function getActions()
    {
        return $this->actions;
    }
    /**
     * This method is responsible for validating the values passed to the setActions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActionsForArrayConstraintsFromSetActions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyActionsItem) {
            // validation for constraint: itemType
            if (!$policyActionsItem instanceof \App\Insis\StructType\Application) {
                $invalidValues[] = is_object($policyActionsItem) ? get_class($policyActionsItem) : sprintf('%s(%s)', gettype($policyActionsItem), var_export($policyActionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actions property can only contain items of type \App\Insis\StructType\Application, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actions value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Application[] $actions
     * @return \App\Insis\StructType\Policy
     */
    public function setActions(array $actions = array())
    {
        // validation for constraint: array
        if ('' !== ($actionsArrayErrorMessage = self::validateActionsForArrayConstraintsFromSetActions($actions))) {
            throw new \InvalidArgumentException($actionsArrayErrorMessage, __LINE__);
        }
        $this->actions = $actions;
        return $this;
    }
    /**
     * Add item to actions value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Application $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToActions(\App\Insis\StructType\Application $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Application) {
            throw new \InvalidArgumentException(sprintf('The actions property can only contain items of type \App\Insis\StructType\Application, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actions[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\Policy
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get actEndDate value
     * @return string|null
     */
    public function getActEndDate()
    {
        return $this->actEndDate;
    }
    /**
     * Set actEndDate value
     * @param string $actEndDate
     * @return \App\Insis\StructType\Policy
     */
    public function setActEndDate($actEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($actEndDate) && !is_string($actEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actEndDate, true), gettype($actEndDate)), __LINE__);
        }
        $this->actEndDate = $actEndDate;
        return $this;
    }
    /**
     * Get blanks value
     * @return \App\Insis\StructType\PolicyBlanks[]|null
     */
    public function getBlanks()
    {
        return $this->blanks;
    }
    /**
     * This method is responsible for validating the values passed to the setBlanks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlanks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBlanksForArrayConstraintsFromSetBlanks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyBlanksItem) {
            // validation for constraint: itemType
            if (!$policyBlanksItem instanceof \App\Insis\StructType\PolicyBlanks) {
                $invalidValues[] = is_object($policyBlanksItem) ? get_class($policyBlanksItem) : sprintf('%s(%s)', gettype($policyBlanksItem), var_export($policyBlanksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The blanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set blanks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks[] $blanks
     * @return \App\Insis\StructType\Policy
     */
    public function setBlanks(array $blanks = array())
    {
        // validation for constraint: array
        if ('' !== ($blanksArrayErrorMessage = self::validateBlanksForArrayConstraintsFromSetBlanks($blanks))) {
            throw new \InvalidArgumentException($blanksArrayErrorMessage, __LINE__);
        }
        $this->blanks = $blanks;
        return $this;
    }
    /**
     * Add item to blanks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToBlanks(\App\Insis\StructType\PolicyBlanks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PolicyBlanks) {
            throw new \InvalidArgumentException(sprintf('The blanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->blanks[] = $item;
        return $this;
    }
    /**
     * Get insureds value
     * @return \App\Insis\StructType\People[]|null
     */
    public function getInsureds()
    {
        return $this->insureds;
    }
    /**
     * This method is responsible for validating the values passed to the setInsureds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsureds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuredsForArrayConstraintsFromSetInsureds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyInsuredsItem) {
            // validation for constraint: itemType
            if (!$policyInsuredsItem instanceof \App\Insis\StructType\People) {
                $invalidValues[] = is_object($policyInsuredsItem) ? get_class($policyInsuredsItem) : sprintf('%s(%s)', gettype($policyInsuredsItem), var_export($policyInsuredsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The insureds property can only contain items of type \App\Insis\StructType\People, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set insureds value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\People[] $insureds
     * @return \App\Insis\StructType\Policy
     */
    public function setInsureds(array $insureds = array())
    {
        // validation for constraint: array
        if ('' !== ($insuredsArrayErrorMessage = self::validateInsuredsForArrayConstraintsFromSetInsureds($insureds))) {
            throw new \InvalidArgumentException($insuredsArrayErrorMessage, __LINE__);
        }
        $this->insureds = $insureds;
        return $this;
    }
    /**
     * Add item to insureds value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\People $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToInsureds(\App\Insis\StructType\People $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\People) {
            throw new \InvalidArgumentException(sprintf('The insureds property can only contain items of type \App\Insis\StructType\People, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->insureds[] = $item;
        return $this;
    }
    /**
     * Get objects value
     * @return \App\Insis\StructType\PolicyObject[]|null
     */
    public function getObjects()
    {
        return $this->objects;
    }
    /**
     * This method is responsible for validating the values passed to the setObjects method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjects method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectsForArrayConstraintsFromSetObjects(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyObjectsItem) {
            // validation for constraint: itemType
            if (!$policyObjectsItem instanceof \App\Insis\StructType\PolicyObject) {
                $invalidValues[] = is_object($policyObjectsItem) ? get_class($policyObjectsItem) : sprintf('%s(%s)', gettype($policyObjectsItem), var_export($policyObjectsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The objects property can only contain items of type \App\Insis\StructType\PolicyObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set objects value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyObject[] $objects
     * @return \App\Insis\StructType\Policy
     */
    public function setObjects(array $objects = array())
    {
        // validation for constraint: array
        if ('' !== ($objectsArrayErrorMessage = self::validateObjectsForArrayConstraintsFromSetObjects($objects))) {
            throw new \InvalidArgumentException($objectsArrayErrorMessage, __LINE__);
        }
        $this->objects = $objects;
        return $this;
    }
    /**
     * Add item to objects value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyObject $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToObjects(\App\Insis\StructType\PolicyObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PolicyObject) {
            throw new \InvalidArgumentException(sprintf('The objects property can only contain items of type \App\Insis\StructType\PolicyObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->objects[] = $item;
        return $this;
    }
    /**
     * Get payments value
     * @return \App\Insis\StructType\Payment[]|null
     */
    public function getPayments()
    {
        return $this->payments;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentsForArrayConstraintsFromSetPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyPaymentsItem) {
            // validation for constraint: itemType
            if (!$policyPaymentsItem instanceof \App\Insis\StructType\Payment) {
                $invalidValues[] = is_object($policyPaymentsItem) ? get_class($policyPaymentsItem) : sprintf('%s(%s)', gettype($policyPaymentsItem), var_export($policyPaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payments property can only contain items of type \App\Insis\StructType\Payment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Payment[] $payments
     * @return \App\Insis\StructType\Policy
     */
    public function setPayments(array $payments = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentsArrayErrorMessage = self::validatePaymentsForArrayConstraintsFromSetPayments($payments))) {
            throw new \InvalidArgumentException($paymentsArrayErrorMessage, __LINE__);
        }
        $this->payments = $payments;
        return $this;
    }
    /**
     * Add item to payments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Payment $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToPayments(\App\Insis\StructType\Payment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Payment) {
            throw new \InvalidArgumentException(sprintf('The payments property can only contain items of type \App\Insis\StructType\Payment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payments[] = $item;
        return $this;
    }
    /**
     * Get changeUserID value
     * @return int|null
     */
    public function getChangeUserID()
    {
        return $this->changeUserID;
    }
    /**
     * Set changeUserID value
     * @param int $changeUserID
     * @return \App\Insis\StructType\Policy
     */
    public function setChangeUserID($changeUserID = null)
    {
        // validation for constraint: int
        if (!is_null($changeUserID) && !(is_int($changeUserID) || ctype_digit($changeUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($changeUserID, true), gettype($changeUserID)), __LINE__);
        }
        $this->changeUserID = $changeUserID;
        return $this;
    }
    /**
     * Get changeDate value
     * @return string|null
     */
    public function getChangeDate()
    {
        return $this->changeDate;
    }
    /**
     * Set changeDate value
     * @param string $changeDate
     * @return \App\Insis\StructType\Policy
     */
    public function setChangeDate($changeDate = null)
    {
        // validation for constraint: string
        if (!is_null($changeDate) && !is_string($changeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeDate, true), gettype($changeDate)), __LINE__);
        }
        $this->changeDate = $changeDate;
        return $this;
    }
    /**
     * Get salesChanelID value
     * @return int|null
     */
    public function getSalesChanelID()
    {
        return $this->salesChanelID;
    }
    /**
     * Set salesChanelID value
     * @param int $salesChanelID
     * @return \App\Insis\StructType\Policy
     */
    public function setSalesChanelID($salesChanelID = null)
    {
        // validation for constraint: int
        if (!is_null($salesChanelID) && !(is_int($salesChanelID) || ctype_digit($salesChanelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesChanelID, true), gettype($salesChanelID)), __LINE__);
        }
        $this->salesChanelID = $salesChanelID;
        return $this;
    }
    /**
     * Get attachments value
     * @return \App\Insis\StructType\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentsForArrayConstraintsFromSetAttachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyAttachmentsItem) {
            // validation for constraint: itemType
            if (!$policyAttachmentsItem instanceof \App\Insis\StructType\Attachment) {
                $invalidValues[] = is_object($policyAttachmentsItem) ? get_class($policyAttachmentsItem) : sprintf('%s(%s)', gettype($policyAttachmentsItem), var_export($policyAttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachments property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment[] $attachments
     * @return \App\Insis\StructType\Policy
     */
    public function setAttachments(array $attachments = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentsArrayErrorMessage = self::validateAttachmentsForArrayConstraintsFromSetAttachments($attachments))) {
            throw new \InvalidArgumentException($attachmentsArrayErrorMessage, __LINE__);
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToAttachments(\App\Insis\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get souvenirs value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getSouvenirs()
    {
        return $this->souvenirs;
    }
    /**
     * This method is responsible for validating the values passed to the setSouvenirs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSouvenirs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSouvenirsForArrayConstraintsFromSetSouvenirs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policySouvenirsItem) {
            // validation for constraint: itemType
            if (!$policySouvenirsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($policySouvenirsItem) ? get_class($policySouvenirsItem) : sprintf('%s(%s)', gettype($policySouvenirsItem), var_export($policySouvenirsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The souvenirs property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set souvenirs value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $souvenirs
     * @return \App\Insis\StructType\Policy
     */
    public function setSouvenirs(array $souvenirs = array())
    {
        // validation for constraint: array
        if ('' !== ($souvenirsArrayErrorMessage = self::validateSouvenirsForArrayConstraintsFromSetSouvenirs($souvenirs))) {
            throw new \InvalidArgumentException($souvenirsArrayErrorMessage, __LINE__);
        }
        $this->souvenirs = $souvenirs;
        return $this;
    }
    /**
     * Add item to souvenirs value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToSouvenirs(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The souvenirs property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->souvenirs[] = $item;
        return $this;
    }
    /**
     * Get apps value
     * @return \App\Insis\StructType\Application[]|null
     */
    public function getApps()
    {
        return $this->apps;
    }
    /**
     * This method is responsible for validating the values passed to the setApps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApps method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAppsForArrayConstraintsFromSetApps(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyAppsItem) {
            // validation for constraint: itemType
            if (!$policyAppsItem instanceof \App\Insis\StructType\Application) {
                $invalidValues[] = is_object($policyAppsItem) ? get_class($policyAppsItem) : sprintf('%s(%s)', gettype($policyAppsItem), var_export($policyAppsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The apps property can only contain items of type \App\Insis\StructType\Application, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set apps value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Application[] $apps
     * @return \App\Insis\StructType\Policy
     */
    public function setApps(array $apps = array())
    {
        // validation for constraint: array
        if ('' !== ($appsArrayErrorMessage = self::validateAppsForArrayConstraintsFromSetApps($apps))) {
            throw new \InvalidArgumentException($appsArrayErrorMessage, __LINE__);
        }
        $this->apps = $apps;
        return $this;
    }
    /**
     * Add item to apps value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Application $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToApps(\App\Insis\StructType\Application $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Application) {
            throw new \InvalidArgumentException(sprintf('The apps property can only contain items of type \App\Insis\StructType\Application, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->apps[] = $item;
        return $this;
    }
    /**
     * Get variableParams value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getVariableParams()
    {
        return $this->variableParams;
    }
    /**
     * This method is responsible for validating the values passed to the setVariableParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariableParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariableParamsForArrayConstraintsFromSetVariableParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyVariableParamsItem) {
            // validation for constraint: itemType
            if (!$policyVariableParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($policyVariableParamsItem) ? get_class($policyVariableParamsItem) : sprintf('%s(%s)', gettype($policyVariableParamsItem), var_export($policyVariableParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @return \App\Insis\StructType\Policy
     */
    public function setVariableParams(array $variableParams = array())
    {
        // validation for constraint: array
        if ('' !== ($variableParamsArrayErrorMessage = self::validateVariableParamsForArrayConstraintsFromSetVariableParams($variableParams))) {
            throw new \InvalidArgumentException($variableParamsArrayErrorMessage, __LINE__);
        }
        $this->variableParams = $variableParams;
        return $this;
    }
    /**
     * Add item to variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToVariableParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variableParams[] = $item;
        return $this;
    }
    /**
     * Get doNotUseCSDB value
     * @return bool|null
     */
    public function getDoNotUseCSDB()
    {
        return $this->doNotUseCSDB;
    }
    /**
     * Set doNotUseCSDB value
     * @param bool $doNotUseCSDB
     * @return \App\Insis\StructType\Policy
     */
    public function setDoNotUseCSDB($doNotUseCSDB = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotUseCSDB) && !is_bool($doNotUseCSDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotUseCSDB, true), gettype($doNotUseCSDB)), __LINE__);
        }
        $this->doNotUseCSDB = $doNotUseCSDB;
        return $this;
    }
    /**
     * Get doNotUse1C value
     * @return bool|null
     */
    public function getDoNotUse1C()
    {
        return $this->doNotUse1C;
    }
    /**
     * Set doNotUse1C value
     * @param bool $doNotUse1C
     * @return \App\Insis\StructType\Policy
     */
    public function setDoNotUse1C($doNotUse1C = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotUse1C) && !is_bool($doNotUse1C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotUse1C, true), gettype($doNotUse1C)), __LINE__);
        }
        $this->doNotUse1C = $doNotUse1C;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \App\Insis\StructType\Policy
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get customRefound value
     * @return bool|null
     */
    public function getCustomRefound()
    {
        return $this->customRefound;
    }
    /**
     * Set customRefound value
     * @param bool $customRefound
     * @return \App\Insis\StructType\Policy
     */
    public function setCustomRefound($customRefound = null)
    {
        // validation for constraint: boolean
        if (!is_null($customRefound) && !is_bool($customRefound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customRefound, true), gettype($customRefound)), __LINE__);
        }
        $this->customRefound = $customRefound;
        return $this;
    }
    /**
     * Get doNotUseArchiveUsedPolicy value
     * @return bool|null
     */
    public function getDoNotUseArchiveUsedPolicy()
    {
        return $this->doNotUseArchiveUsedPolicy;
    }
    /**
     * Set doNotUseArchiveUsedPolicy value
     * @param bool $doNotUseArchiveUsedPolicy
     * @return \App\Insis\StructType\Policy
     */
    public function setDoNotUseArchiveUsedPolicy($doNotUseArchiveUsedPolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotUseArchiveUsedPolicy) && !is_bool($doNotUseArchiveUsedPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotUseArchiveUsedPolicy, true), gettype($doNotUseArchiveUsedPolicy)), __LINE__);
        }
        $this->doNotUseArchiveUsedPolicy = $doNotUseArchiveUsedPolicy;
        return $this;
    }
    /**
     * Get podft value
     * @return string|null
     */
    public function getPodft()
    {
        return $this->podft;
    }
    /**
     * Set podft value
     * @param string $podft
     * @return \App\Insis\StructType\Policy
     */
    public function setPodft($podft = null)
    {
        // validation for constraint: string
        if (!is_null($podft) && !is_string($podft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podft, true), gettype($podft)), __LINE__);
        }
        $this->podft = $podft;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Insis\StructType\Policy
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get verifications value
     * @return int[]|null
     */
    public function getVerifications()
    {
        return $this->verifications;
    }
    /**
     * This method is responsible for validating the values passed to the setVerifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerificationsForArrayConstraintsFromSetVerifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyVerificationsItem) {
            // validation for constraint: itemType
            if (!(is_int($policyVerificationsItem) || ctype_digit($policyVerificationsItem))) {
                $invalidValues[] = is_object($policyVerificationsItem) ? get_class($policyVerificationsItem) : sprintf('%s(%s)', gettype($policyVerificationsItem), var_export($policyVerificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verifications property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verifications value
     * @throws \InvalidArgumentException
     * @param int[] $verifications
     * @return \App\Insis\StructType\Policy
     */
    public function setVerifications(array $verifications = array())
    {
        // validation for constraint: array
        if ('' !== ($verificationsArrayErrorMessage = self::validateVerificationsForArrayConstraintsFromSetVerifications($verifications))) {
            throw new \InvalidArgumentException($verificationsArrayErrorMessage, __LINE__);
        }
        $this->verifications = $verifications;
        return $this;
    }
    /**
     * Add item to verifications value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\Insis\StructType\Policy
     */
    public function addToVerifications($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The verifications property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verifications[] = $item;
        return $this;
    }
    /**
     * Get VerificationBool value
     * @return bool|null
     */
    public function getVerificationBool()
    {
        return $this->VerificationBool;
    }
    /**
     * Set VerificationBool value
     * @param bool $verificationBool
     * @return \App\Insis\StructType\Policy
     */
    public function setVerificationBool($verificationBool = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationBool) && !is_bool($verificationBool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationBool, true), gettype($verificationBool)), __LINE__);
        }
        $this->VerificationBool = $verificationBool;
        return $this;
    }
    /**
     * Get OnlineBool value
     * @return bool|null
     */
    public function getOnlineBool()
    {
        return $this->OnlineBool;
    }
    /**
     * Set OnlineBool value
     * @param bool $onlineBool
     * @return \App\Insis\StructType\Policy
     */
    public function setOnlineBool($onlineBool = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlineBool) && !is_bool($onlineBool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlineBool, true), gettype($onlineBool)), __LINE__);
        }
        $this->OnlineBool = $onlineBool;
        return $this;
    }
}
