<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pledger StructType
 * @subpackage Structs
 */
class Pledger extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\HcsbkItem[]
     */
    public $item;
    /**
     * Constructor method for pledger
     * @uses Pledger::setItem()
     * @param \App\Insis\StructType\HcsbkItem[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\HcsbkItem[]|null
     */
    public function getItem()
    {
        return isset($this->item) ? $this->item : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pledgerItemItem) {
            // validation for constraint: itemType
            if (!$pledgerItemItem instanceof \App\Insis\StructType\HcsbkItem) {
                $invalidValues[] = is_object($pledgerItemItem) ? get_class($pledgerItemItem) : sprintf('%s(%s)', gettype($pledgerItemItem), var_export($pledgerItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \App\Insis\StructType\HcsbkItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkItem[] $item
     * @return \App\Insis\StructType\Pledger
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->item);
        } else {
            $this->item = $item;
        }
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkItem $item
     * @return \App\Insis\StructType\Pledger
     */
    public function addToItem(\App\Insis\StructType\HcsbkItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\HcsbkItem) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \App\Insis\StructType\HcsbkItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
}
