<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for peopleDocument StructType
 * @subpackage Structs
 */
class PeopleDocument extends AbstractStructBase
{
    /**
     * The docAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\Attachment[]
     */
    public $docAttachment;
    /**
     * The docEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docEndDate;
    /**
     * The docId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $docId;
    /**
     * The docIssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docIssueDate;
    /**
     * The docIssueOrg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docIssueOrg;
    /**
     * The docNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docNumber;
    /**
     * The docType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docType;
    /**
     * Constructor method for peopleDocument
     * @uses PeopleDocument::setDocAttachment()
     * @uses PeopleDocument::setDocEndDate()
     * @uses PeopleDocument::setDocId()
     * @uses PeopleDocument::setDocIssueDate()
     * @uses PeopleDocument::setDocIssueOrg()
     * @uses PeopleDocument::setDocNumber()
     * @uses PeopleDocument::setDocType()
     * @param \App\Insis\StructType\Attachment[] $docAttachment
     * @param string $docEndDate
     * @param int $docId
     * @param string $docIssueDate
     * @param string $docIssueOrg
     * @param string $docNumber
     * @param string $docType
     */
    public function __construct(array $docAttachment = array(), $docEndDate = null, $docId = null, $docIssueDate = null, $docIssueOrg = null, $docNumber = null, $docType = null)
    {
        $this
            ->setDocAttachment($docAttachment)
            ->setDocEndDate($docEndDate)
            ->setDocId($docId)
            ->setDocIssueDate($docIssueDate)
            ->setDocIssueOrg($docIssueOrg)
            ->setDocNumber($docNumber)
            ->setDocType($docType);
    }
    /**
     * Get docAttachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\Attachment[]|null
     */
    public function getDocAttachment()
    {
        return isset($this->docAttachment) ? $this->docAttachment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocAttachmentForArrayConstraintsFromSetDocAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleDocumentDocAttachmentItem) {
            // validation for constraint: itemType
            if (!$peopleDocumentDocAttachmentItem instanceof \App\Insis\StructType\Attachment) {
                $invalidValues[] = is_object($peopleDocumentDocAttachmentItem) ? get_class($peopleDocumentDocAttachmentItem) : sprintf('%s(%s)', gettype($peopleDocumentDocAttachmentItem), var_export($peopleDocumentDocAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The docAttachment property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set docAttachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment[] $docAttachment
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocAttachment(array $docAttachment = array())
    {
        // validation for constraint: array
        if ('' !== ($docAttachmentArrayErrorMessage = self::validateDocAttachmentForArrayConstraintsFromSetDocAttachment($docAttachment))) {
            throw new \InvalidArgumentException($docAttachmentArrayErrorMessage, __LINE__);
        }
        if (is_null($docAttachment) || (is_array($docAttachment) && empty($docAttachment))) {
            unset($this->docAttachment);
        } else {
            $this->docAttachment = $docAttachment;
        }
        return $this;
    }
    /**
     * Add item to docAttachment value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment $item
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function addToDocAttachment(\App\Insis\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The docAttachment property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->docAttachment[] = $item;
        return $this;
    }
    /**
     * Get docEndDate value
     * @return string|null
     */
    public function getDocEndDate()
    {
        return $this->docEndDate;
    }
    /**
     * Set docEndDate value
     * @param string $docEndDate
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocEndDate($docEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($docEndDate) && !is_string($docEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docEndDate, true), gettype($docEndDate)), __LINE__);
        }
        $this->docEndDate = $docEndDate;
        return $this;
    }
    /**
     * Get docId value
     * @return int|null
     */
    public function getDocId()
    {
        return $this->docId;
    }
    /**
     * Set docId value
     * @param int $docId
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocId($docId = null)
    {
        // validation for constraint: int
        if (!is_null($docId) && !(is_int($docId) || ctype_digit($docId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docId, true), gettype($docId)), __LINE__);
        }
        $this->docId = $docId;
        return $this;
    }
    /**
     * Get docIssueDate value
     * @return string|null
     */
    public function getDocIssueDate()
    {
        return $this->docIssueDate;
    }
    /**
     * Set docIssueDate value
     * @param string $docIssueDate
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocIssueDate($docIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueDate) && !is_string($docIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueDate, true), gettype($docIssueDate)), __LINE__);
        }
        $this->docIssueDate = $docIssueDate;
        return $this;
    }
    /**
     * Get docIssueOrg value
     * @return string|null
     */
    public function getDocIssueOrg()
    {
        return $this->docIssueOrg;
    }
    /**
     * Set docIssueOrg value
     * @param string $docIssueOrg
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocIssueOrg($docIssueOrg = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueOrg) && !is_string($docIssueOrg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueOrg, true), gettype($docIssueOrg)), __LINE__);
        }
        $this->docIssueOrg = $docIssueOrg;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->docType;
    }
    /**
     * Set docType value
     * @param string $docType
     * @return \App\Insis\StructType\PeopleDocument
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docType, true), gettype($docType)), __LINE__);
        }
        $this->docType = $docType;
        return $this;
    }
}
