<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for People StructType
 * @subpackage Structs
 */
class People extends PolicyObject
{
    /**
     * The manID
     * @var int
     */
    public $manID;
    /**
     * The rnn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rnn;
    /**
     * The bin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bin;
    /**
     * The activityKindID
     * @var string
     */
    public $activityKindID;
    /**
     * The companyOccupationID
     * @var string
     */
    public $companyOccupationID;
    /**
     * The manComp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manComp;
    /**
     * The contacts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $contacts;
    /**
     * The addresses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Address[]
     */
    public $addresses;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The fName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fName;
    /**
     * The sName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sName;
    /**
     * The lName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lName;
    /**
     * The sex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sex;
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\PeopleDocument[]
     */
    public $documents;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The foreigner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $foreigner;
    /**
     * The foreignerContryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $foreignerContryID;
    /**
     * The doNotUseCSDB
     * @var bool
     */
    public $doNotUseCSDB;
    /**
     * The peopleType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $peopleType;
    /**
     * The decsr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $decsr;
    /**
     * The bankInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\BankAccount[]
     */
    public $bankInfo;
    /**
     * The Beneficiary
     * @var bool
     */
    public $Beneficiary;
    /**
     * The ListBeneficiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ListBeneficiary;
    /**
     * The ForeignPublicOfficials
     * @var bool
     */
    public $ForeignPublicOfficials;
    /**
     * The ListForeignPublicOfficials
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ListForeignPublicOfficials;
    /**
     * The VerificationBool
     * @var bool
     */
    public $VerificationBool;
    /**
     * The addressesKATO
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\AddressKATO[]
     */
    public $addressesKATO;
    /**
     * Constructor method for People
     * @uses People::setManID()
     * @uses People::setRnn()
     * @uses People::setBin()
     * @uses People::setActivityKindID()
     * @uses People::setCompanyOccupationID()
     * @uses People::setManComp()
     * @uses People::setContacts()
     * @uses People::setAddresses()
     * @uses People::setTitle()
     * @uses People::setFName()
     * @uses People::setSName()
     * @uses People::setLName()
     * @uses People::setSex()
     * @uses People::setDocuments()
     * @uses People::setBirthDate()
     * @uses People::setForeigner()
     * @uses People::setForeignerContryID()
     * @uses People::setDoNotUseCSDB()
     * @uses People::setPeopleType()
     * @uses People::setDecsr()
     * @uses People::setBankInfo()
     * @uses People::setBeneficiary()
     * @uses People::setListBeneficiary()
     * @uses People::setForeignPublicOfficials()
     * @uses People::setListForeignPublicOfficials()
     * @uses People::setVerificationBool()
     * @uses People::setAddressesKATO()
     * @param int $manID
     * @param string $rnn
     * @param string $bin
     * @param string $activityKindID
     * @param string $companyOccupationID
     * @param int $manComp
     * @param \App\Insis\StructType\ObjectParam[] $contacts
     * @param \App\Insis\StructType\Address[] $addresses
     * @param string $title
     * @param string $fName
     * @param string $sName
     * @param string $lName
     * @param int $sex
     * @param \App\Insis\StructType\PeopleDocument[] $documents
     * @param string $birthDate
     * @param string $foreigner
     * @param string $foreignerContryID
     * @param bool $doNotUseCSDB
     * @param int[] $peopleType
     * @param string $decsr
     * @param \App\Insis\StructType\BankAccount[] $bankInfo
     * @param bool $beneficiary
     * @param int[] $listBeneficiary
     * @param bool $foreignPublicOfficials
     * @param int[] $listForeignPublicOfficials
     * @param bool $verificationBool
     * @param \App\Insis\StructType\AddressKATO[] $addressesKATO
     */
    public function __construct($manID = null, $rnn = null, $bin = null, $activityKindID = null, $companyOccupationID = null, $manComp = null, array $contacts = array(), array $addresses = array(), $title = null, $fName = null, $sName = null, $lName = null, $sex = null, array $documents = array(), $birthDate = null, $foreigner = null, $foreignerContryID = null, $doNotUseCSDB = null, array $peopleType = array(), $decsr = null, array $bankInfo = array(), $beneficiary = null, array $listBeneficiary = array(), $foreignPublicOfficials = null, array $listForeignPublicOfficials = array(), $verificationBool = null, array $addressesKATO = array())
    {
        $this
            ->setManID($manID)
            ->setRnn($rnn)
            ->setBin($bin)
            ->setActivityKindID($activityKindID)
            ->setCompanyOccupationID($companyOccupationID)
            ->setManComp($manComp)
            ->setContacts($contacts)
            ->setAddresses($addresses)
            ->setTitle($title)
            ->setFName($fName)
            ->setSName($sName)
            ->setLName($lName)
            ->setSex($sex)
            ->setDocuments($documents)
            ->setBirthDate($birthDate)
            ->setForeigner($foreigner)
            ->setForeignerContryID($foreignerContryID)
            ->setDoNotUseCSDB($doNotUseCSDB)
            ->setPeopleType($peopleType)
            ->setDecsr($decsr)
            ->setBankInfo($bankInfo)
            ->setBeneficiary($beneficiary)
            ->setListBeneficiary($listBeneficiary)
            ->setForeignPublicOfficials($foreignPublicOfficials)
            ->setListForeignPublicOfficials($listForeignPublicOfficials)
            ->setVerificationBool($verificationBool)
            ->setAddressesKATO($addressesKATO);
    }
    /**
     * Get manID value
     * @return int|null
     */
    public function getManID()
    {
        return $this->manID;
    }
    /**
     * Set manID value
     * @param int $manID
     * @return \App\Insis\StructType\People
     */
    public function setManID($manID = null)
    {
        // validation for constraint: int
        if (!is_null($manID) && !(is_int($manID) || ctype_digit($manID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manID, true), gettype($manID)), __LINE__);
        }
        $this->manID = $manID;
        return $this;
    }
    /**
     * Get rnn value
     * @return string|null
     */
    public function getRnn()
    {
        return $this->rnn;
    }
    /**
     * Set rnn value
     * @param string $rnn
     * @return \App\Insis\StructType\People
     */
    public function setRnn($rnn = null)
    {
        // validation for constraint: string
        if (!is_null($rnn) && !is_string($rnn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rnn, true), gettype($rnn)), __LINE__);
        }
        $this->rnn = $rnn;
        return $this;
    }
    /**
     * Get bin value
     * @return string|null
     */
    public function getBin()
    {
        return $this->bin;
    }
    /**
     * Set bin value
     * @param string $bin
     * @return \App\Insis\StructType\People
     */
    public function setBin($bin = null)
    {
        // validation for constraint: string
        if (!is_null($bin) && !is_string($bin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin, true), gettype($bin)), __LINE__);
        }
        $this->bin = $bin;
        return $this;
    }
    /**
     * Get activityKindID value
     * @return string|null
     */
    public function getActivityKindID()
    {
        return $this->activityKindID;
    }
    /**
     * Set activityKindID value
     * @param string $activityKindID
     * @return \App\Insis\StructType\People
     */
    public function setActivityKindID($activityKindID = null)
    {
        // validation for constraint: string
        if (!is_null($activityKindID) && !is_string($activityKindID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityKindID, true), gettype($activityKindID)), __LINE__);
        }
        $this->activityKindID = $activityKindID;
        return $this;
    }
    /**
     * Get companyOccupationID value
     * @return string|null
     */
    public function getCompanyOccupationID()
    {
        return $this->companyOccupationID;
    }
    /**
     * Set companyOccupationID value
     * @param string $companyOccupationID
     * @return \App\Insis\StructType\People
     */
    public function setCompanyOccupationID($companyOccupationID = null)
    {
        // validation for constraint: string
        if (!is_null($companyOccupationID) && !is_string($companyOccupationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyOccupationID, true), gettype($companyOccupationID)), __LINE__);
        }
        $this->companyOccupationID = $companyOccupationID;
        return $this;
    }
    /**
     * Get manComp value
     * @return int|null
     */
    public function getManComp()
    {
        return $this->manComp;
    }
    /**
     * Set manComp value
     * @param int $manComp
     * @return \App\Insis\StructType\People
     */
    public function setManComp($manComp = null)
    {
        // validation for constraint: int
        if (!is_null($manComp) && !(is_int($manComp) || ctype_digit($manComp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manComp, true), gettype($manComp)), __LINE__);
        }
        $this->manComp = $manComp;
        return $this;
    }
    /**
     * Get contacts value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getContacts()
    {
        return $this->contacts;
    }
    /**
     * This method is responsible for validating the values passed to the setContacts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContacts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactsForArrayConstraintsFromSetContacts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleContactsItem) {
            // validation for constraint: itemType
            if (!$peopleContactsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($peopleContactsItem) ? get_class($peopleContactsItem) : sprintf('%s(%s)', gettype($peopleContactsItem), var_export($peopleContactsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contacts property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contacts value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $contacts
     * @return \App\Insis\StructType\People
     */
    public function setContacts(array $contacts = array())
    {
        // validation for constraint: array
        if ('' !== ($contactsArrayErrorMessage = self::validateContactsForArrayConstraintsFromSetContacts($contacts))) {
            throw new \InvalidArgumentException($contactsArrayErrorMessage, __LINE__);
        }
        $this->contacts = $contacts;
        return $this;
    }
    /**
     * Add item to contacts value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\People
     */
    public function addToContacts(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The contacts property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contacts[] = $item;
        return $this;
    }
    /**
     * Get addresses value
     * @return \App\Insis\StructType\Address[]|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * This method is responsible for validating the values passed to the setAddresses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddresses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressesForArrayConstraintsFromSetAddresses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleAddressesItem) {
            // validation for constraint: itemType
            if (!$peopleAddressesItem instanceof \App\Insis\StructType\Address) {
                $invalidValues[] = is_object($peopleAddressesItem) ? get_class($peopleAddressesItem) : sprintf('%s(%s)', gettype($peopleAddressesItem), var_export($peopleAddressesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The addresses property can only contain items of type \App\Insis\StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set addresses value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Address[] $addresses
     * @return \App\Insis\StructType\People
     */
    public function setAddresses(array $addresses = array())
    {
        // validation for constraint: array
        if ('' !== ($addressesArrayErrorMessage = self::validateAddressesForArrayConstraintsFromSetAddresses($addresses))) {
            throw new \InvalidArgumentException($addressesArrayErrorMessage, __LINE__);
        }
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Add item to addresses value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Address $item
     * @return \App\Insis\StructType\People
     */
    public function addToAddresses(\App\Insis\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The addresses property can only contain items of type \App\Insis\StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->addresses[] = $item;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Insis\StructType\People
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get fName value
     * @return string|null
     */
    public function getFName()
    {
        return $this->fName;
    }
    /**
     * Set fName value
     * @param string $fName
     * @return \App\Insis\StructType\People
     */
    public function setFName($fName = null)
    {
        // validation for constraint: string
        if (!is_null($fName) && !is_string($fName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fName, true), gettype($fName)), __LINE__);
        }
        $this->fName = $fName;
        return $this;
    }
    /**
     * Get sName value
     * @return string|null
     */
    public function getSName()
    {
        return $this->sName;
    }
    /**
     * Set sName value
     * @param string $sName
     * @return \App\Insis\StructType\People
     */
    public function setSName($sName = null)
    {
        // validation for constraint: string
        if (!is_null($sName) && !is_string($sName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sName, true), gettype($sName)), __LINE__);
        }
        $this->sName = $sName;
        return $this;
    }
    /**
     * Get lName value
     * @return string|null
     */
    public function getLName()
    {
        return $this->lName;
    }
    /**
     * Set lName value
     * @param string $lName
     * @return \App\Insis\StructType\People
     */
    public function setLName($lName = null)
    {
        // validation for constraint: string
        if (!is_null($lName) && !is_string($lName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lName, true), gettype($lName)), __LINE__);
        }
        $this->lName = $lName;
        return $this;
    }
    /**
     * Get sex value
     * @return int|null
     */
    public function getSex()
    {
        return $this->sex;
    }
    /**
     * Set sex value
     * @param int $sex
     * @return \App\Insis\StructType\People
     */
    public function setSex($sex = null)
    {
        // validation for constraint: int
        if (!is_null($sex) && !(is_int($sex) || ctype_digit($sex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sex, true), gettype($sex)), __LINE__);
        }
        $this->sex = $sex;
        return $this;
    }
    /**
     * Get documents value
     * @return \App\Insis\StructType\PeopleDocument[]|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleDocumentsItem) {
            // validation for constraint: itemType
            if (!$peopleDocumentsItem instanceof \App\Insis\StructType\PeopleDocument) {
                $invalidValues[] = is_object($peopleDocumentsItem) ? get_class($peopleDocumentsItem) : sprintf('%s(%s)', gettype($peopleDocumentsItem), var_export($peopleDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documents property can only contain items of type \App\Insis\StructType\PeopleDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documents value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PeopleDocument[] $documents
     * @return \App\Insis\StructType\People
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        $this->documents = $documents;
        return $this;
    }
    /**
     * Add item to documents value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PeopleDocument $item
     * @return \App\Insis\StructType\People
     */
    public function addToDocuments(\App\Insis\StructType\PeopleDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PeopleDocument) {
            throw new \InvalidArgumentException(sprintf('The documents property can only contain items of type \App\Insis\StructType\PeopleDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documents[] = $item;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \App\Insis\StructType\People
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get foreigner value
     * @return string|null
     */
    public function getForeigner()
    {
        return $this->foreigner;
    }
    /**
     * Set foreigner value
     * @param string $foreigner
     * @return \App\Insis\StructType\People
     */
    public function setForeigner($foreigner = null)
    {
        // validation for constraint: string
        if (!is_null($foreigner) && !is_string($foreigner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreigner, true), gettype($foreigner)), __LINE__);
        }
        $this->foreigner = $foreigner;
        return $this;
    }
    /**
     * Get foreignerContryID value
     * @return string|null
     */
    public function getForeignerContryID()
    {
        return $this->foreignerContryID;
    }
    /**
     * Set foreignerContryID value
     * @param string $foreignerContryID
     * @return \App\Insis\StructType\People
     */
    public function setForeignerContryID($foreignerContryID = null)
    {
        // validation for constraint: string
        if (!is_null($foreignerContryID) && !is_string($foreignerContryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignerContryID, true), gettype($foreignerContryID)), __LINE__);
        }
        $this->foreignerContryID = $foreignerContryID;
        return $this;
    }
    /**
     * Get doNotUseCSDB value
     * @return bool|null
     */
    public function getDoNotUseCSDB()
    {
        return $this->doNotUseCSDB;
    }
    /**
     * Set doNotUseCSDB value
     * @param bool $doNotUseCSDB
     * @return \App\Insis\StructType\People
     */
    public function setDoNotUseCSDB($doNotUseCSDB = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotUseCSDB) && !is_bool($doNotUseCSDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotUseCSDB, true), gettype($doNotUseCSDB)), __LINE__);
        }
        $this->doNotUseCSDB = $doNotUseCSDB;
        return $this;
    }
    /**
     * Get peopleType value
     * @return int[]|null
     */
    public function getPeopleType()
    {
        return $this->peopleType;
    }
    /**
     * This method is responsible for validating the values passed to the setPeopleType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeopleType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeopleTypeForArrayConstraintsFromSetPeopleType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peoplePeopleTypeItem) {
            // validation for constraint: itemType
            if (!(is_int($peoplePeopleTypeItem) || ctype_digit($peoplePeopleTypeItem))) {
                $invalidValues[] = is_object($peoplePeopleTypeItem) ? get_class($peoplePeopleTypeItem) : sprintf('%s(%s)', gettype($peoplePeopleTypeItem), var_export($peoplePeopleTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The peopleType property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set peopleType value
     * @throws \InvalidArgumentException
     * @param int[] $peopleType
     * @return \App\Insis\StructType\People
     */
    public function setPeopleType(array $peopleType = array())
    {
        // validation for constraint: array
        if ('' !== ($peopleTypeArrayErrorMessage = self::validatePeopleTypeForArrayConstraintsFromSetPeopleType($peopleType))) {
            throw new \InvalidArgumentException($peopleTypeArrayErrorMessage, __LINE__);
        }
        $this->peopleType = $peopleType;
        return $this;
    }
    /**
     * Add item to peopleType value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\Insis\StructType\People
     */
    public function addToPeopleType($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The peopleType property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->peopleType[] = $item;
        return $this;
    }
    /**
     * Get decsr value
     * @return string|null
     */
    public function getDecsr()
    {
        return $this->decsr;
    }
    /**
     * Set decsr value
     * @param string $decsr
     * @return \App\Insis\StructType\People
     */
    public function setDecsr($decsr = null)
    {
        // validation for constraint: string
        if (!is_null($decsr) && !is_string($decsr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decsr, true), gettype($decsr)), __LINE__);
        }
        $this->decsr = $decsr;
        return $this;
    }
    /**
     * Get bankInfo value
     * @return \App\Insis\StructType\BankAccount[]|null
     */
    public function getBankInfo()
    {
        return $this->bankInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setBankInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankInfoForArrayConstraintsFromSetBankInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleBankInfoItem) {
            // validation for constraint: itemType
            if (!$peopleBankInfoItem instanceof \App\Insis\StructType\BankAccount) {
                $invalidValues[] = is_object($peopleBankInfoItem) ? get_class($peopleBankInfoItem) : sprintf('%s(%s)', gettype($peopleBankInfoItem), var_export($peopleBankInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bankInfo property can only contain items of type \App\Insis\StructType\BankAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bankInfo value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\BankAccount[] $bankInfo
     * @return \App\Insis\StructType\People
     */
    public function setBankInfo(array $bankInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($bankInfoArrayErrorMessage = self::validateBankInfoForArrayConstraintsFromSetBankInfo($bankInfo))) {
            throw new \InvalidArgumentException($bankInfoArrayErrorMessage, __LINE__);
        }
        $this->bankInfo = $bankInfo;
        return $this;
    }
    /**
     * Add item to bankInfo value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\BankAccount $item
     * @return \App\Insis\StructType\People
     */
    public function addToBankInfo(\App\Insis\StructType\BankAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\BankAccount) {
            throw new \InvalidArgumentException(sprintf('The bankInfo property can only contain items of type \App\Insis\StructType\BankAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bankInfo[] = $item;
        return $this;
    }
    /**
     * Get Beneficiary value
     * @return bool|null
     */
    public function getBeneficiary()
    {
        return $this->Beneficiary;
    }
    /**
     * Set Beneficiary value
     * @param bool $beneficiary
     * @return \App\Insis\StructType\People
     */
    public function setBeneficiary($beneficiary = null)
    {
        // validation for constraint: boolean
        if (!is_null($beneficiary) && !is_bool($beneficiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($beneficiary, true), gettype($beneficiary)), __LINE__);
        }
        $this->Beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Get ListBeneficiary value
     * @return int[]|null
     */
    public function getListBeneficiary()
    {
        return $this->ListBeneficiary;
    }
    /**
     * This method is responsible for validating the values passed to the setListBeneficiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListBeneficiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListBeneficiaryForArrayConstraintsFromSetListBeneficiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleListBeneficiaryItem) {
            // validation for constraint: itemType
            if (!(is_int($peopleListBeneficiaryItem) || ctype_digit($peopleListBeneficiaryItem))) {
                $invalidValues[] = is_object($peopleListBeneficiaryItem) ? get_class($peopleListBeneficiaryItem) : sprintf('%s(%s)', gettype($peopleListBeneficiaryItem), var_export($peopleListBeneficiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListBeneficiary property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListBeneficiary value
     * @throws \InvalidArgumentException
     * @param int[] $listBeneficiary
     * @return \App\Insis\StructType\People
     */
    public function setListBeneficiary(array $listBeneficiary = array())
    {
        // validation for constraint: array
        if ('' !== ($listBeneficiaryArrayErrorMessage = self::validateListBeneficiaryForArrayConstraintsFromSetListBeneficiary($listBeneficiary))) {
            throw new \InvalidArgumentException($listBeneficiaryArrayErrorMessage, __LINE__);
        }
        $this->ListBeneficiary = $listBeneficiary;
        return $this;
    }
    /**
     * Add item to ListBeneficiary value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\Insis\StructType\People
     */
    public function addToListBeneficiary($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The ListBeneficiary property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListBeneficiary[] = $item;
        return $this;
    }
    /**
     * Get ForeignPublicOfficials value
     * @return bool|null
     */
    public function getForeignPublicOfficials()
    {
        return $this->ForeignPublicOfficials;
    }
    /**
     * Set ForeignPublicOfficials value
     * @param bool $foreignPublicOfficials
     * @return \App\Insis\StructType\People
     */
    public function setForeignPublicOfficials($foreignPublicOfficials = null)
    {
        // validation for constraint: boolean
        if (!is_null($foreignPublicOfficials) && !is_bool($foreignPublicOfficials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($foreignPublicOfficials, true), gettype($foreignPublicOfficials)), __LINE__);
        }
        $this->ForeignPublicOfficials = $foreignPublicOfficials;
        return $this;
    }
    /**
     * Get ListForeignPublicOfficials value
     * @return int[]|null
     */
    public function getListForeignPublicOfficials()
    {
        return $this->ListForeignPublicOfficials;
    }
    /**
     * This method is responsible for validating the values passed to the setListForeignPublicOfficials method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListForeignPublicOfficials method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListForeignPublicOfficialsForArrayConstraintsFromSetListForeignPublicOfficials(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleListForeignPublicOfficialsItem) {
            // validation for constraint: itemType
            if (!(is_int($peopleListForeignPublicOfficialsItem) || ctype_digit($peopleListForeignPublicOfficialsItem))) {
                $invalidValues[] = is_object($peopleListForeignPublicOfficialsItem) ? get_class($peopleListForeignPublicOfficialsItem) : sprintf('%s(%s)', gettype($peopleListForeignPublicOfficialsItem), var_export($peopleListForeignPublicOfficialsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListForeignPublicOfficials property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListForeignPublicOfficials value
     * @throws \InvalidArgumentException
     * @param int[] $listForeignPublicOfficials
     * @return \App\Insis\StructType\People
     */
    public function setListForeignPublicOfficials(array $listForeignPublicOfficials = array())
    {
        // validation for constraint: array
        if ('' !== ($listForeignPublicOfficialsArrayErrorMessage = self::validateListForeignPublicOfficialsForArrayConstraintsFromSetListForeignPublicOfficials($listForeignPublicOfficials))) {
            throw new \InvalidArgumentException($listForeignPublicOfficialsArrayErrorMessage, __LINE__);
        }
        $this->ListForeignPublicOfficials = $listForeignPublicOfficials;
        return $this;
    }
    /**
     * Add item to ListForeignPublicOfficials value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\Insis\StructType\People
     */
    public function addToListForeignPublicOfficials($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The ListForeignPublicOfficials property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListForeignPublicOfficials[] = $item;
        return $this;
    }
    /**
     * Get VerificationBool value
     * @return bool|null
     */
    public function getVerificationBool()
    {
        return $this->VerificationBool;
    }
    /**
     * Set VerificationBool value
     * @param bool $verificationBool
     * @return \App\Insis\StructType\People
     */
    public function setVerificationBool($verificationBool = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationBool) && !is_bool($verificationBool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationBool, true), gettype($verificationBool)), __LINE__);
        }
        $this->VerificationBool = $verificationBool;
        return $this;
    }
    /**
     * Get addressesKATO value
     * @return \App\Insis\StructType\AddressKATO[]|null
     */
    public function getAddressesKATO()
    {
        return $this->addressesKATO;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressesKATO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressesKATO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressesKATOForArrayConstraintsFromSetAddressesKATO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $peopleAddressesKATOItem) {
            // validation for constraint: itemType
            if (!$peopleAddressesKATOItem instanceof \App\Insis\StructType\AddressKATO) {
                $invalidValues[] = is_object($peopleAddressesKATOItem) ? get_class($peopleAddressesKATOItem) : sprintf('%s(%s)', gettype($peopleAddressesKATOItem), var_export($peopleAddressesKATOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The addressesKATO property can only contain items of type \App\Insis\StructType\AddressKATO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set addressesKATO value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\AddressKATO[] $addressesKATO
     * @return \App\Insis\StructType\People
     */
    public function setAddressesKATO(array $addressesKATO = array())
    {
        // validation for constraint: array
        if ('' !== ($addressesKATOArrayErrorMessage = self::validateAddressesKATOForArrayConstraintsFromSetAddressesKATO($addressesKATO))) {
            throw new \InvalidArgumentException($addressesKATOArrayErrorMessage, __LINE__);
        }
        $this->addressesKATO = $addressesKATO;
        return $this;
    }
    /**
     * Add item to addressesKATO value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\AddressKATO $item
     * @return \App\Insis\StructType\People
     */
    public function addToAddressesKATO(\App\Insis\StructType\AddressKATO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\AddressKATO) {
            throw new \InvalidArgumentException(sprintf('The addressesKATO property can only contain items of type \App\Insis\StructType\AddressKATO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->addressesKATO[] = $item;
        return $this;
    }
}
