<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectCustom StructType
 * @subpackage Structs
 */
class ObjectCustom extends PolicyObject
{
    /**
     * The customType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customType;
    /**
     * Constructor method for objectCustom
     * @uses ObjectCustom::setCustomType()
     * @param int $customType
     */
    public function __construct($customType = null)
    {
        $this
            ->setCustomType($customType);
    }
    /**
     * Get customType value
     * @return int|null
     */
    public function getCustomType()
    {
        return $this->customType;
    }
    /**
     * Set customType value
     * @param int $customType
     * @return \App\Insis\StructType\ObjectCustom
     */
    public function setCustomType($customType = null)
    {
        // validation for constraint: int
        if (!is_null($customType) && !(is_int($customType) || ctype_digit($customType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customType, true), gettype($customType)), __LINE__);
        }
        $this->customType = $customType;
        return $this;
    }
}
