<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectCover StructType
 * @subpackage Structs
 */
class ObjectCover extends AbstractStructBase
{
    /**
     * The coverType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverType;
    /**
     * The coverValueCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverValueCurrency;
    /**
     * The coverValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $coverValue;
    /**
     * The coverPremiumCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverPremiumCurrency;
    /**
     * The coverPremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $coverPremium;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Discount;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Tariff
     */
    public $tariff;
    /**
     * The variableParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $variableParams;
    /**
     * The coverRisks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\CoverRisk[]
     */
    public $coverRisks;
    /**
     * Constructor method for ObjectCover
     * @uses ObjectCover::setCoverType()
     * @uses ObjectCover::setCoverValueCurrency()
     * @uses ObjectCover::setCoverValue()
     * @uses ObjectCover::setCoverPremiumCurrency()
     * @uses ObjectCover::setCoverPremium()
     * @uses ObjectCover::setDiscount()
     * @uses ObjectCover::setTariff()
     * @uses ObjectCover::setVariableParams()
     * @uses ObjectCover::setCoverRisks()
     * @param string $coverType
     * @param string $coverValueCurrency
     * @param float $coverValue
     * @param string $coverPremiumCurrency
     * @param float $coverPremium
     * @param float $discount
     * @param \App\Insis\StructType\Tariff $tariff
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @param \App\Insis\StructType\CoverRisk[] $coverRisks
     */
    public function __construct($coverType = null, $coverValueCurrency = null, $coverValue = null, $coverPremiumCurrency = null, $coverPremium = null, $discount = null, \App\Insis\StructType\Tariff $tariff = null, array $variableParams = array(), array $coverRisks = array())
    {
        $this
            ->setCoverType($coverType)
            ->setCoverValueCurrency($coverValueCurrency)
            ->setCoverValue($coverValue)
            ->setCoverPremiumCurrency($coverPremiumCurrency)
            ->setCoverPremium($coverPremium)
            ->setDiscount($discount)
            ->setTariff($tariff)
            ->setVariableParams($variableParams)
            ->setCoverRisks($coverRisks);
    }
    /**
     * Get coverType value
     * @return string|null
     */
    public function getCoverType()
    {
        return $this->coverType;
    }
    /**
     * Set coverType value
     * @param string $coverType
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setCoverType($coverType = null)
    {
        // validation for constraint: string
        if (!is_null($coverType) && !is_string($coverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverType, true), gettype($coverType)), __LINE__);
        }
        $this->coverType = $coverType;
        return $this;
    }
    /**
     * Get coverValueCurrency value
     * @return string|null
     */
    public function getCoverValueCurrency()
    {
        return $this->coverValueCurrency;
    }
    /**
     * Set coverValueCurrency value
     * @param string $coverValueCurrency
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setCoverValueCurrency($coverValueCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($coverValueCurrency) && !is_string($coverValueCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverValueCurrency, true), gettype($coverValueCurrency)), __LINE__);
        }
        $this->coverValueCurrency = $coverValueCurrency;
        return $this;
    }
    /**
     * Get coverValue value
     * @return float|null
     */
    public function getCoverValue()
    {
        return $this->coverValue;
    }
    /**
     * Set coverValue value
     * @param float $coverValue
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setCoverValue($coverValue = null)
    {
        // validation for constraint: float
        if (!is_null($coverValue) && !(is_float($coverValue) || is_numeric($coverValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coverValue, true), gettype($coverValue)), __LINE__);
        }
        $this->coverValue = $coverValue;
        return $this;
    }
    /**
     * Get coverPremiumCurrency value
     * @return string|null
     */
    public function getCoverPremiumCurrency()
    {
        return $this->coverPremiumCurrency;
    }
    /**
     * Set coverPremiumCurrency value
     * @param string $coverPremiumCurrency
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setCoverPremiumCurrency($coverPremiumCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($coverPremiumCurrency) && !is_string($coverPremiumCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverPremiumCurrency, true), gettype($coverPremiumCurrency)), __LINE__);
        }
        $this->coverPremiumCurrency = $coverPremiumCurrency;
        return $this;
    }
    /**
     * Get coverPremium value
     * @return float|null
     */
    public function getCoverPremium()
    {
        return $this->coverPremium;
    }
    /**
     * Set coverPremium value
     * @param float $coverPremium
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setCoverPremium($coverPremium = null)
    {
        // validation for constraint: float
        if (!is_null($coverPremium) && !(is_float($coverPremium) || is_numeric($coverPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coverPremium, true), gettype($coverPremium)), __LINE__);
        }
        $this->coverPremium = $coverPremium;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get tariff value
     * @return \App\Insis\StructType\Tariff|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param \App\Insis\StructType\Tariff $tariff
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setTariff(\App\Insis\StructType\Tariff $tariff = null)
    {
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get variableParams value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getVariableParams()
    {
        return $this->variableParams;
    }
    /**
     * This method is responsible for validating the values passed to the setVariableParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariableParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariableParamsForArrayConstraintsFromSetVariableParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectCoverVariableParamsItem) {
            // validation for constraint: itemType
            if (!$objectCoverVariableParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($objectCoverVariableParamsItem) ? get_class($objectCoverVariableParamsItem) : sprintf('%s(%s)', gettype($objectCoverVariableParamsItem), var_export($objectCoverVariableParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setVariableParams(array $variableParams = array())
    {
        // validation for constraint: array
        if ('' !== ($variableParamsArrayErrorMessage = self::validateVariableParamsForArrayConstraintsFromSetVariableParams($variableParams))) {
            throw new \InvalidArgumentException($variableParamsArrayErrorMessage, __LINE__);
        }
        $this->variableParams = $variableParams;
        return $this;
    }
    /**
     * Add item to variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\ObjectCover
     */
    public function addToVariableParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variableParams[] = $item;
        return $this;
    }
    /**
     * Get coverRisks value
     * @return \App\Insis\StructType\CoverRisk[]|null
     */
    public function getCoverRisks()
    {
        return $this->coverRisks;
    }
    /**
     * This method is responsible for validating the values passed to the setCoverRisks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoverRisks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoverRisksForArrayConstraintsFromSetCoverRisks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectCoverCoverRisksItem) {
            // validation for constraint: itemType
            if (!$objectCoverCoverRisksItem instanceof \App\Insis\StructType\CoverRisk) {
                $invalidValues[] = is_object($objectCoverCoverRisksItem) ? get_class($objectCoverCoverRisksItem) : sprintf('%s(%s)', gettype($objectCoverCoverRisksItem), var_export($objectCoverCoverRisksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The coverRisks property can only contain items of type \App\Insis\StructType\CoverRisk, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set coverRisks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\CoverRisk[] $coverRisks
     * @return \App\Insis\StructType\ObjectCover
     */
    public function setCoverRisks(array $coverRisks = array())
    {
        // validation for constraint: array
        if ('' !== ($coverRisksArrayErrorMessage = self::validateCoverRisksForArrayConstraintsFromSetCoverRisks($coverRisks))) {
            throw new \InvalidArgumentException($coverRisksArrayErrorMessage, __LINE__);
        }
        $this->coverRisks = $coverRisks;
        return $this;
    }
    /**
     * Add item to coverRisks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\CoverRisk $item
     * @return \App\Insis\StructType\ObjectCover
     */
    public function addToCoverRisks(\App\Insis\StructType\CoverRisk $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\CoverRisk) {
            throw new \InvalidArgumentException(sprintf('The coverRisks property can only contain items of type \App\Insis\StructType\CoverRisk, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->coverRisks[] = $item;
        return $this;
    }
}
