<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectCargo StructType
 * @subpackage Structs
 */
class ObjectCargo extends PolicyObject
{
    /**
     * The cargoType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cargoType;
    /**
     * The cargoSubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cargoSubType;
    /**
     * The cargoDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoDescription;
    /**
     * The packingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packingType;
    /**
     * The boxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $boxNumber;
    /**
     * The teritoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $teritoryID;
    /**
     * The fromPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromPlace;
    /**
     * The toPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toPlace;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $transportType;
    /**
     * The vehicleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vehicleType;
    /**
     * The tripType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tripType;
    /**
     * The orderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderName;
    /**
     * The tripDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tripDescription;
    /**
     * Constructor method for objectCargo
     * @uses ObjectCargo::setCargoType()
     * @uses ObjectCargo::setCargoSubType()
     * @uses ObjectCargo::setCargoDescription()
     * @uses ObjectCargo::setPackingType()
     * @uses ObjectCargo::setBoxNumber()
     * @uses ObjectCargo::setTeritoryID()
     * @uses ObjectCargo::setFromPlace()
     * @uses ObjectCargo::setToPlace()
     * @uses ObjectCargo::setDestination()
     * @uses ObjectCargo::setTransportType()
     * @uses ObjectCargo::setVehicleType()
     * @uses ObjectCargo::setTripType()
     * @uses ObjectCargo::setOrderName()
     * @uses ObjectCargo::setTripDescription()
     * @param int $cargoType
     * @param int $cargoSubType
     * @param string $cargoDescription
     * @param int $packingType
     * @param int $boxNumber
     * @param int $teritoryID
     * @param string $fromPlace
     * @param string $toPlace
     * @param string $destination
     * @param int $transportType
     * @param int $vehicleType
     * @param string $tripType
     * @param string $orderName
     * @param string $tripDescription
     */
    public function __construct($cargoType = null, $cargoSubType = null, $cargoDescription = null, $packingType = null, $boxNumber = null, $teritoryID = null, $fromPlace = null, $toPlace = null, $destination = null, $transportType = null, $vehicleType = null, $tripType = null, $orderName = null, $tripDescription = null)
    {
        $this
            ->setCargoType($cargoType)
            ->setCargoSubType($cargoSubType)
            ->setCargoDescription($cargoDescription)
            ->setPackingType($packingType)
            ->setBoxNumber($boxNumber)
            ->setTeritoryID($teritoryID)
            ->setFromPlace($fromPlace)
            ->setToPlace($toPlace)
            ->setDestination($destination)
            ->setTransportType($transportType)
            ->setVehicleType($vehicleType)
            ->setTripType($tripType)
            ->setOrderName($orderName)
            ->setTripDescription($tripDescription);
    }
    /**
     * Get cargoType value
     * @return int|null
     */
    public function getCargoType()
    {
        return $this->cargoType;
    }
    /**
     * Set cargoType value
     * @param int $cargoType
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setCargoType($cargoType = null)
    {
        // validation for constraint: int
        if (!is_null($cargoType) && !(is_int($cargoType) || ctype_digit($cargoType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cargoType, true), gettype($cargoType)), __LINE__);
        }
        $this->cargoType = $cargoType;
        return $this;
    }
    /**
     * Get cargoSubType value
     * @return int|null
     */
    public function getCargoSubType()
    {
        return $this->cargoSubType;
    }
    /**
     * Set cargoSubType value
     * @param int $cargoSubType
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setCargoSubType($cargoSubType = null)
    {
        // validation for constraint: int
        if (!is_null($cargoSubType) && !(is_int($cargoSubType) || ctype_digit($cargoSubType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cargoSubType, true), gettype($cargoSubType)), __LINE__);
        }
        $this->cargoSubType = $cargoSubType;
        return $this;
    }
    /**
     * Get cargoDescription value
     * @return string|null
     */
    public function getCargoDescription()
    {
        return $this->cargoDescription;
    }
    /**
     * Set cargoDescription value
     * @param string $cargoDescription
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setCargoDescription($cargoDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cargoDescription) && !is_string($cargoDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoDescription, true), gettype($cargoDescription)), __LINE__);
        }
        $this->cargoDescription = $cargoDescription;
        return $this;
    }
    /**
     * Get packingType value
     * @return int|null
     */
    public function getPackingType()
    {
        return $this->packingType;
    }
    /**
     * Set packingType value
     * @param int $packingType
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setPackingType($packingType = null)
    {
        // validation for constraint: int
        if (!is_null($packingType) && !(is_int($packingType) || ctype_digit($packingType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packingType, true), gettype($packingType)), __LINE__);
        }
        $this->packingType = $packingType;
        return $this;
    }
    /**
     * Get boxNumber value
     * @return int|null
     */
    public function getBoxNumber()
    {
        return $this->boxNumber;
    }
    /**
     * Set boxNumber value
     * @param int $boxNumber
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setBoxNumber($boxNumber = null)
    {
        // validation for constraint: int
        if (!is_null($boxNumber) && !(is_int($boxNumber) || ctype_digit($boxNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxNumber, true), gettype($boxNumber)), __LINE__);
        }
        $this->boxNumber = $boxNumber;
        return $this;
    }
    /**
     * Get teritoryID value
     * @return int|null
     */
    public function getTeritoryID()
    {
        return $this->teritoryID;
    }
    /**
     * Set teritoryID value
     * @param int $teritoryID
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setTeritoryID($teritoryID = null)
    {
        // validation for constraint: int
        if (!is_null($teritoryID) && !(is_int($teritoryID) || ctype_digit($teritoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($teritoryID, true), gettype($teritoryID)), __LINE__);
        }
        $this->teritoryID = $teritoryID;
        return $this;
    }
    /**
     * Get fromPlace value
     * @return string|null
     */
    public function getFromPlace()
    {
        return $this->fromPlace;
    }
    /**
     * Set fromPlace value
     * @param string $fromPlace
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setFromPlace($fromPlace = null)
    {
        // validation for constraint: string
        if (!is_null($fromPlace) && !is_string($fromPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromPlace, true), gettype($fromPlace)), __LINE__);
        }
        $this->fromPlace = $fromPlace;
        return $this;
    }
    /**
     * Get toPlace value
     * @return string|null
     */
    public function getToPlace()
    {
        return $this->toPlace;
    }
    /**
     * Set toPlace value
     * @param string $toPlace
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setToPlace($toPlace = null)
    {
        // validation for constraint: string
        if (!is_null($toPlace) && !is_string($toPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toPlace, true), gettype($toPlace)), __LINE__);
        }
        $this->toPlace = $toPlace;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get transportType value
     * @return int|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @param int $transportType
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setTransportType($transportType = null)
    {
        // validation for constraint: int
        if (!is_null($transportType) && !(is_int($transportType) || ctype_digit($transportType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transportType, true), gettype($transportType)), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get vehicleType value
     * @return int|null
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }
    /**
     * Set vehicleType value
     * @param int $vehicleType
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleType) && !(is_int($vehicleType) || ctype_digit($vehicleType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleType, true), gettype($vehicleType)), __LINE__);
        }
        $this->vehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get tripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->tripType;
    }
    /**
     * Set tripType value
     * @param string $tripType
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: string
        if (!is_null($tripType) && !is_string($tripType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripType, true), gettype($tripType)), __LINE__);
        }
        $this->tripType = $tripType;
        return $this;
    }
    /**
     * Get orderName value
     * @return string|null
     */
    public function getOrderName()
    {
        return $this->orderName;
    }
    /**
     * Set orderName value
     * @param string $orderName
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setOrderName($orderName = null)
    {
        // validation for constraint: string
        if (!is_null($orderName) && !is_string($orderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderName, true), gettype($orderName)), __LINE__);
        }
        $this->orderName = $orderName;
        return $this;
    }
    /**
     * Get tripDescription value
     * @return string|null
     */
    public function getTripDescription()
    {
        return $this->tripDescription;
    }
    /**
     * Set tripDescription value
     * @param string $tripDescription
     * @return \App\Insis\StructType\ObjectCargo
     */
    public function setTripDescription($tripDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tripDescription) && !is_string($tripDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripDescription, true), gettype($tripDescription)), __LINE__);
        }
        $this->tripDescription = $tripDescription;
        return $this;
    }
}
